/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class UserFunctionCall
extends FunctionCall
implements InstructionInfoProvider {
    private SequenceType staticType;
    private UserFunction function;
    private boolean tailRecursive = false;
    private boolean confirmed = false;

    public void setStaticType(SequenceType sequenceType) {
        this.staticType = sequenceType;
    }

    public void setFunction(UserFunction userFunction, StaticContext staticContext) throws XPathException {
        this.function = userFunction;
        this.confirmed = true;
        int n = userFunction.getNumberOfArguments();
        SequenceType[] sequenceTypeArray = userFunction.getArgumentTypes();
        int n2 = 0;
        while (n2 < n) {
            String string = userFunction.getFunctionDisplayName(staticContext.getNamePool());
            RoleLocator roleLocator = new RoleLocator(0, string, n2);
            this.argument[n2] = TypeChecker.staticTypeCheck(this.argument[n2], sequenceTypeArray[n2], false, roleLocator, staticContext);
            ++n2;
        }
    }

    public UserFunction getFunction() {
        return this.function;
    }

    public void setConfirmed(boolean bl) {
        this.confirmed = bl;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public ItemType getItemType() {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 1792;
        }
        return this.staticType.getCardinality();
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        int n = 0;
        while (n < this.argument.length) {
            this.argument[n] = this.argument[n].simplify(staticContext);
            ++n;
        }
        return this;
    }

    public boolean markTailFunctionCalls() {
        this.tailRecursive = true;
        return true;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Value value = this.callFunction(xPathContext);
        if (value instanceof Item) {
            return (Item)((Object)value);
        }
        return value.iterate(xPathContext).next();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return this.callFunction(xPathContext).iterate(xPathContext);
    }

    private Value callFunction(XPathContext xPathContext) throws XPathException {
        int n = this.argument.length;
        Value[] valueArray = new Value[n];
        int n2 = 0;
        while (n2 < n) {
            valueArray[n2] = ExpressionTool.lazyEvaluate(this.argument[n2], xPathContext);
            ++n2;
        }
        if (this.tailRecursive) {
            return new FunctionCallPackage(this.function, valueArray, xPathContext);
        }
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this);
        return this.function.call(valueArray, xPathContextMajor, true);
    }

    public Value dynamicCall(Value[] valueArray, XPathContext xPathContext) throws XPathException {
        Value[] valueArray2 = new Value[valueArray.length];
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.openStackFrame(valueArray.length);
        int n = 0;
        while (n < valueArray.length) {
            xPathContextMajor.setLocalVariable(n, valueArray[n]);
            valueArray2[n] = ExpressionTool.lazyEvaluate(this.argument[n], xPathContextMajor);
            ++n;
        }
        XPathContextMajor xPathContextMajor2 = xPathContextMajor.newCleanContext();
        xPathContextMajor2.setOrigin(this);
        return this.function.call(valueArray2, xPathContextMajor2, true);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "function " + this.getDisplayName(namePool) + (this.tailRecursive ? " (tail call)" : ""));
        int n2 = 0;
        while (n2 < this.argument.length) {
            this.argument[n2].display(n + 1, namePool, printStream);
            ++n2;
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(2009);
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setObjectNameCode(this.getFunctionNameCode());
        instructionDetails.setProperty("expression", this);
        instructionDetails.setProperty("target", this.function);
        return instructionDetails;
    }

    public class FunctionCallPackage
    extends ObjectValue {
        private UserFunction function;
        private Value[] actualArgs;
        private XPathContext evaluationContext;

        public FunctionCallPackage(UserFunction userFunction, Value[] valueArray, XPathContext xPathContext) {
            this.function = userFunction;
            this.actualArgs = valueArray;
            this.evaluationContext = xPathContext;
            this.setValue(this);
        }

        public Value call() throws XPathException {
            XPathContextMajor xPathContextMajor = this.evaluationContext.newCleanContext();
            xPathContextMajor.setOrigin(UserFunctionCall.this);
            return this.function.call(this.actualArgs, xPathContextMajor, false);
        }

        public Value appendTo(SequenceReceiver sequenceReceiver) throws XPathException {
            Value value = this.call();
            SequenceIterator sequenceIterator = value.iterate(this.evaluationContext);
            Item item;
            while ((item = sequenceIterator.next()) != null) {
                if (item instanceof FunctionCallPackage) {
                    return (Value)((Object)item);
                }
                sequenceReceiver.append(item, UserFunctionCall.this.locationId);
            }
            return null;
        }
    }
}

