/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.XPathException;

public abstract class SimpleExpression
extends ComputedExpression {
    public static final int EVALUATE_METHOD = 0;
    public static final int ITERATE_METHOD = 1;
    public static final int PROCESS_METHOD = 2;
    protected Expression[] arguments = new Expression[0];

    public void setArguments(Expression[] expressionArray) {
        this.arguments = expressionArray;
    }

    public Iterator iterateSubExpressions() {
        return Arrays.asList(this.arguments).iterator();
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        int n = 0;
        while (n < this.arguments.length) {
            if (this.arguments[n] != null) {
                this.arguments[n] = this.arguments[n].simplify(staticContext);
            }
            ++n;
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        int n = 0;
        while (n < this.arguments.length) {
            if (this.arguments[n] != null) {
                this.arguments[n] = this.arguments[n].analyze(staticContext, itemType);
            }
            ++n;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        int n = 0;
        while (n < this.arguments.length) {
            if (this.arguments[n] != null) {
                this.arguments[n] = this.arguments[n].promote(promotionOffer);
            }
            ++n;
        }
        return this;
    }

    public ItemType getItemType() {
        return Type.ITEM_TYPE;
    }

    public int computeCardinality() {
        if (this.getImplementationMethod() == 0) {
            return 768;
        }
        return 1536;
    }

    public int computeDependencies() {
        return super.computeDependencies();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        int n = this.getImplementationMethod();
        switch (n) {
            case 0: {
                this.dynamicError("evaluateItem() is not implemented in the subclass " + this.getClass(), xPathContext);
            }
            case 1: {
                return this.iterate(xPathContext).next();
            }
            case 2: {
                Controller controller = xPathContext.getController();
                XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
                xPathContextMinor.setOrigin(this);
                SequenceOutputter sequenceOutputter = new SequenceOutputter();
                sequenceOutputter.setConfiguration(controller.getConfiguration());
                xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
                this.process(xPathContextMinor);
                return sequenceOutputter.getFirstItem();
            }
        }
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        int n = this.getImplementationMethod();
        switch (n) {
            case 0: {
                Item item = this.evaluateItem(xPathContext);
                if (item == null) {
                    return EmptyIterator.getInstance();
                }
                return SingletonIterator.makeIterator(item);
            }
            case 1: {
                this.dynamicError("iterate() is not implemented in the subclass " + this.getClass(), xPathContext);
                break;
            }
            case 2: {
                Controller controller = xPathContext.getController();
                XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
                xPathContextMinor.setOrigin(this);
                SequenceOutputter sequenceOutputter = new SequenceOutputter();
                sequenceOutputter.setConfiguration(controller.getConfiguration());
                xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
                this.process(xPathContextMinor);
                return sequenceOutputter.getSequence().iterate(xPathContext);
            }
        }
        return null;
    }

    public void process(XPathContext xPathContext) throws XPathException {
        int n = this.getImplementationMethod();
        switch (n) {
            case 0: {
                Item item = this.evaluateItem(xPathContext);
                xPathContext.getReceiver().append(item, this.locationId);
                break;
            }
            case 1: {
                Item item;
                SequenceIterator sequenceIterator = this.iterate(xPathContext);
                while ((item = sequenceIterator.next()) != null) {
                    xPathContext.getReceiver().append(item, this.locationId);
                }
                break;
            }
            case 2: {
                this.dynamicError("process() is not implemented in the subclass " + this.getClass(), xPathContext);
            }
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + this.getExpressionType());
        int n2 = 0;
        while (n2 < this.arguments.length) {
            this.arguments[n2].display(n + 1, namePool, printStream);
            ++n2;
        }
    }

    public String getExpressionType() {
        return this.getClass().getName();
    }
}

