/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.SingleNodeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public class RootExpression
extends SingleNodeExpression {
    public Expression simplify(StaticContext staticContext) throws StaticError {
        return this;
    }

    public boolean equals(Object object) {
        return object instanceof RootExpression;
    }

    public final int computeCardinality() {
        return 512;
    }

    public int hashCode() {
        return "RootExpression".hashCode();
    }

    public NodeInfo getNode(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            this.dynamicError("Finding root of tree: the context item is not set", xPathContext);
        }
        if (item instanceof NodeInfo) {
            DocumentInfo documentInfo = ((NodeInfo)item).getDocumentRoot();
            if (documentInfo == null) {
                this.dynamicError("The root of the tree containing the context item is not a document node", xPathContext);
            }
            return documentInfo;
        }
        this.dynamicError("Finding root of tree: the context item is not a node", xPathContext);
        return null;
    }

    public int getIntrinsicDependencies() {
        return 65552;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "/");
    }
}

