/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastAsQName;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class CastExpression
extends UnaryExpression {
    private AtomicType targetType;
    private boolean allowEmpty = false;

    public CastExpression(Expression expression, AtomicType atomicType, boolean bl) {
        super(expression);
        this.allowEmpty = bl;
        this.targetType = atomicType;
        this.adoptChildExpression(expression);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.operand instanceof AtomicValue) {
            return this.analyze(staticContext, Type.ITEM_TYPE);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        SequenceType sequenceType = new SequenceType(Type.ANY_ATOMIC_TYPE, this.getCardinality());
        RoleLocator roleLocator = new RoleLocator(2, "cast as", 0);
        this.operand = TypeChecker.staticTypeCheck(this.operand, sequenceType, false, roleLocator, staticContext);
        if (Type.isSubType(this.operand.getItemType(), this.targetType)) {
            return this.operand;
        }
        if (Type.isSubType(this.targetType, Type.QNAME_TYPE)) {
            return new CastAsQName(this.operand).analyze(staticContext, itemType);
        }
        if (this.operand instanceof AtomicValue) {
            return (AtomicValue)this.evaluateItem(null);
        }
        return this;
    }

    public int computeCardinality() {
        return this.allowEmpty ? 768 : 512;
    }

    public ItemType getItemType() {
        return this.targetType;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operand.evaluateItem(xPathContext);
        if (atomicValue == null) {
            if (this.allowEmpty) {
                return null;
            }
            DynamicError dynamicError = new DynamicError("Cast does not allow an empty sequence");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        try {
            return atomicValue.convert(this.targetType, xPathContext);
        }
        catch (XPathException xPathException) {
            this.dynamicError(xPathException.getMessage(), xPathContext);
            return null;
        }
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.targetType == ((CastExpression)object).targetType && this.allowEmpty == ((CastExpression)object).allowEmpty;
    }

    protected String displayOperator(NamePool namePool) {
        return "cast as " + this.targetType.toString(namePool);
    }
}

