/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.CDATAFilter;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.HTMLEmitter;
import net.sf.saxon.event.HTMLIndenter;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.XHTMLEmitter;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.event.XMLIndenter;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.xpath.XPathException;

public class UncommittedEmitter
extends Emitter {
    boolean committed = false;
    boolean initialNewline = false;
    Receiver baseReceiver = null;
    List pending = null;

    public void open() throws XPathException {
        this.committed = false;
    }

    public void close() throws XPathException {
        if (!this.committed) {
            this.switchToXML();
        }
        this.baseReceiver.close();
    }

    public void startDocument(int n) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.startDocument(n);
        }
    }

    public void endDocument() throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.endDocument();
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (!this.committed) {
            if (this.pending == null) {
                this.pending = new ArrayList();
            }
            PendingNode pendingNode = new PendingNode();
            pendingNode.kind = 3;
            pendingNode.name = null;
            pendingNode.content = charSequence;
            pendingNode.locationId = n;
            pendingNode.properties = n2;
            this.pending.add(pendingNode);
            if (!Navigator.isWhite(charSequence)) {
                this.switchToXML();
            }
        } else {
            this.baseReceiver.characters(charSequence, n, n2);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (!this.committed) {
            if (this.pending == null) {
                this.pending = new ArrayList();
            }
            PendingNode pendingNode = new PendingNode();
            pendingNode.kind = 7;
            pendingNode.name = string;
            pendingNode.content = charSequence;
            pendingNode.locationId = n;
            pendingNode.properties = n2;
            this.pending.add(pendingNode);
        } else {
            this.baseReceiver.processingInstruction(string, charSequence, n, n2);
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (!this.committed) {
            if (this.pending == null) {
                this.pending = new ArrayList();
            }
            PendingNode pendingNode = new PendingNode();
            pendingNode.kind = 8;
            pendingNode.name = null;
            pendingNode.content = charSequence;
            pendingNode.locationId = n;
            pendingNode.properties = n2;
            this.pending.add(pendingNode);
        } else {
            this.baseReceiver.comment(charSequence, n, n2);
        }
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (!this.committed) {
            String string = this.namePool.getLocalName(n);
            short s = this.namePool.getURICode(n);
            if (string.equalsIgnoreCase("html") && s == 0) {
                this.switchToHTML();
            } else if (string.equals("html") && this.namePool.getURIFromURICode(s) == "http://www.w3.org/1999/xhtml") {
                this.switchToXHTML();
            } else {
                this.switchToXML();
            }
        }
        this.baseReceiver.startElement(n, n2, n3, n4);
    }

    public void namespace(int n, int n2) throws XPathException {
        this.baseReceiver.namespace(n, n2);
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        this.baseReceiver.attribute(n, n2, charSequence, n3, n4);
    }

    public void startContent() throws XPathException {
        this.baseReceiver.startContent();
    }

    public void endElement() throws XPathException {
        this.baseReceiver.endElement();
    }

    private void switchToXML() throws XPathException {
        Object object;
        XMLEmitter xMLEmitter = new XMLEmitter();
        this.baseReceiver = xMLEmitter;
        String string = this.outputProperties.getProperty("indent");
        if (string != null && string.equals("yes")) {
            object = new XMLIndenter();
            ((ProxyReceiver)object).setUnderlyingReceiver(xMLEmitter);
            ((ProxyReceiver)object).setConfiguration(this.config);
            ((XMLIndenter)object).setOutputProperties(this.outputProperties);
            this.baseReceiver = object;
        }
        if ((object = this.outputProperties.getProperty("cdata-section-elements")) != null && ((String)object).length() > 0) {
            CDATAFilter cDATAFilter = new CDATAFilter();
            cDATAFilter.setUnderlyingReceiver(xMLEmitter);
            cDATAFilter.setConfiguration(this.config);
            cDATAFilter.setOutputProperties(this.outputProperties);
            this.baseReceiver = cDATAFilter;
        }
        this.switchTo(xMLEmitter);
    }

    private void switchToXHTML() throws XPathException {
        XHTMLEmitter xHTMLEmitter = new XHTMLEmitter();
        this.baseReceiver = xHTMLEmitter;
        String string = this.outputProperties.getProperty("indent");
        if (string == null || string.equals("yes")) {
            XMLIndenter xMLIndenter = new XMLIndenter();
            xMLIndenter.setUnderlyingReceiver(xHTMLEmitter);
            xMLIndenter.setConfiguration(this.config);
            xMLIndenter.setOutputProperties(this.outputProperties);
            this.baseReceiver = xMLIndenter;
        }
        this.switchTo(xHTMLEmitter);
    }

    private void switchToHTML() throws XPathException {
        HTMLEmitter hTMLEmitter = new HTMLEmitter();
        this.baseReceiver = hTMLEmitter;
        String string = this.outputProperties.getProperty("indent");
        if (string == null || string.equals("yes")) {
            HTMLIndenter hTMLIndenter = new HTMLIndenter();
            hTMLIndenter.setUnderlyingReceiver(hTMLEmitter);
            hTMLIndenter.setConfiguration(this.config);
            hTMLIndenter.setOutputProperties(this.outputProperties);
            this.baseReceiver = hTMLIndenter;
        }
        this.switchTo(hTMLEmitter);
    }

    private void switchTo(Emitter emitter) throws XPathException {
        this.committed = true;
        emitter.setWriter(this.writer);
        emitter.setStreamResult(this.streamResult);
        emitter.characterSet = this.characterSet;
        emitter.setOutputProperties(this.outputProperties);
        emitter.setConfiguration(this.config);
        this.baseReceiver.open();
        if (this.pending != null) {
            int n = 0;
            while (n < this.pending.size()) {
                PendingNode pendingNode = (PendingNode)this.pending.get(n);
                switch (pendingNode.kind) {
                    case 8: {
                        emitter.comment(pendingNode.content, pendingNode.locationId, pendingNode.properties);
                        break;
                    }
                    case 7: {
                        emitter.processingInstruction(pendingNode.name, pendingNode.content, pendingNode.locationId, pendingNode.properties);
                        break;
                    }
                    case 3: {
                        emitter.characters(pendingNode.content, pendingNode.locationId, pendingNode.properties);
                    }
                }
                ++n;
            }
            this.pending = null;
        }
    }

    private static class PendingNode {
        int kind;
        String name;
        CharSequence content;
        int properties;
        int locationId;

        private PendingNode() {
        }
    }
}

