/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.xpath.XPathException;

public class DocumentSender
implements SaxonLocator {
    private NodeInfo top;

    public DocumentSender(NodeInfo nodeInfo) {
        this.top = nodeInfo;
        int n = nodeInfo.getNodeKind();
        if (n != 9 && n != 1) {
            throw new IllegalArgumentException("DocumentSender can only handle document or element nodes");
        }
    }

    public void send(Receiver receiver) throws XPathException {
        if (this.top.getNamePool() != receiver.getConfiguration().getNamePool()) {
            throw new IllegalArgumentException("DocumentSender source and target must use the same NamePool");
        }
        receiver.setSystemId(this.top.getSystemId());
        receiver.setDocumentLocator(this);
        receiver.open();
        this.top.copy(receiver, 2, true, 0);
        receiver.close();
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.top.getSystemId();
    }

    public String getSystemId(int n) {
        return this.getSystemId();
    }

    public int getLineNumber(int n) {
        return this.getLineNumber();
    }
}

