/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TemplatesHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetStripper;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import org.xml.sax.Locator;

public class TemplatesHandlerImpl
extends ReceivingContentHandler
implements TemplatesHandler {
    private TreeBuilder builder;
    private StyleNodeFactory nodeFactory;
    private Templates templates;
    private String systemId;

    protected TemplatesHandlerImpl(Configuration configuration) {
        this.setConfiguration(configuration);
        this.nodeFactory = new StyleNodeFactory(configuration.getNamePool(), configuration.isAllowExternalFunctions());
        StylesheetStripper stylesheetStripper = new StylesheetStripper();
        stylesheetStripper.setStylesheetRules(configuration.getNamePool());
        this.builder = new TreeBuilder();
        this.builder.setConfiguration(configuration);
        this.builder.setNodeFactory(this.nodeFactory);
        this.builder.setLineNumbering(true);
        stylesheetStripper.setUnderlyingReceiver(this.builder);
        CommentStripper commentStripper = new CommentStripper();
        commentStripper.setUnderlyingReceiver(stylesheetStripper);
        this.setReceiver(commentStripper);
    }

    public Templates getTemplates() {
        if (this.templates == null) {
            DocumentImpl documentImpl = (DocumentImpl)this.builder.getCurrentDocument();
            if (documentImpl == null) {
                return null;
            }
            PreparedStylesheet preparedStylesheet = new PreparedStylesheet(this.getConfiguration());
            try {
                preparedStylesheet.setStylesheetDocument(documentImpl, this.nodeFactory);
                this.templates = preparedStylesheet;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new UnsupportedOperationException(transformerConfigurationException.getMessage());
            }
        }
        return this.templates;
    }

    public void setSystemId(String string) {
        this.systemId = string;
        this.builder.setSystemId(string);
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.setSystemId(locator.getSystemId());
    }

    public String getSystemId() {
        return this.systemId;
    }
}

