<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:java="http://xml.apache.org/xalan/java" exclude-result-prefixes="java"
	version='1.0'>
	
	<!-- 
	한글 조사를 처리한다.
	
	-->
	
	<xsl:template match="phrase[@role='postposition' or @role='조사']">
		<xsl:choose>
			<!-- xalan 을 사용하는 경우 -->
			<xsl:when
				test="function-available('java:hangul.pp.Processor.getPostPosition')">
				<xsl:variable name="previous.text">
					<xsl:apply-templates select="preceding-sibling::*[1]"/>
				</xsl:variable>
				
				<xsl:variable name="pp.text">
					<xsl:value-of select="string(.)"/>
				</xsl:variable>
				
				<xsl:value-of
					select="java:hangul.pp.Processor.getPostPosition($previous.text , $pp.text)"/>
			</xsl:when>
			<!-- 이외의 경우 -->
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>
	
</xsl:stylesheet>