<?xml version='1.0' encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
            xmlns:java="http://xml.apache.org/xalan/java" 
            exclude-result-prefixes="java"
            version='1.0'>
                

                
<xsl:import href="docbook-xsl/xhtml/docbook.xsl"/>

<xsl:import href="dbk-html-common.xsl"/>


<xsl:output method="xml" encoding="utf-8"/>


<xsl:template match="/" >
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>없음</title>
    <style type="text/css">
    <xsl:comment>
        .previous-text {
        }
        .pp-text {
            background : yellow ;
            font-weight : bold ;
        }
    </xsl:comment>
    </style>
  </head>
  <body>
  
		<xsl:choose>
			<!-- xalan 을 사용하는 경우 -->
			<xsl:when
				test="function-available('java:hangul.pp.Processor.getPostPosition')">
    
    <table border="1">
        <tr>
            <th>원본 문자열</th><th>원본 조사</th><th>변환 결과</th>
            <th>ID</th><th>linkend</th>
        </tr>
        
        <xsl:apply-templates select="descendant::phrase[@role='조사' 
                                                 or @role='postposition']" />
    </table>				
				
        	</xsl:when>
			<!-- 이외의 경우 -->
			<xsl:otherwise>
				<div class="warning">Xalan 을 사용할 수 없음</div>
			</xsl:otherwise>
		</xsl:choose>
  

  </body>
</html>
</xsl:template>

<xsl:template match="phrase[@role='조사' or @role='postposition']" >
    
    <xsl:variable name="previous.node" select="preceding-sibling::*[1]" />
    <xsl:variable name="previous.text">
	    <xsl:apply-templates select="$previous.node"/>
	</xsl:variable>
	<xsl:variable name="pp.text">
	    <xsl:value-of select="string(.)"/>
	</xsl:variable>
	
	
    <tr>
        <td><xsl:value-of select="$previous.text"/></td>
        <td><xsl:value-of select="$pp.text" /></td>
        <td>
            <span class="previous-text">
                <xsl:value-of select="$previous.text" />
            </span>
            <span class="pp-text">
                <xsl:value-of
					select="java:hangul.pp.Processor.getPostPosition($previous.text , $pp.text)"/>
            </span>
        </td>
        <td>
            <xsl:if test="$previous.node/@id">
                <xsl:value-of select="$previous.node/@id" />
            </xsl:if>
        </td>
        <td>
            <xsl:value-of select="$previous.node/@linkend" />
        </td>
    </tr>
    
</xsl:template>


</xsl:stylesheet>
