<?php // -*-php-*-
rcs_id('$Id: TitleSearch.php,v 1.2 2003/06/22 16:11:11 gryu Exp $');

require_once('lib/TextSearchQuery.php');

/**
 */
class WikiPlugin_TitleSearch
extends	WikiPlugin
{
	var	$name =	'TitleSearch';
	
	function getDefaultArguments() {
		// FIXME: how to exclude multiple pages?
		return array('s' => false,
					 'auto_redirect' => false,
					 'noheader'	=> false
					 );
	}

	function getDefaultFormArguments() {
		$defaults =	parent::getDefaultFormArguments();
		$defaults['description'] = ' ̸ ˻';
		$defaults['buttontext'] = ' ̸ ˻';
		return $defaults;
	}
	
	function run($dbi, $argstr,	$request) {
		$args =	$this->getArgs($argstr,	$request);
		if (empty($args['s']))
			return '';

		extract($args);
		$s = preg_replace('/\'(.*)\'/', '\\1', $s);
		setlocale(LC_CTYPE, 'C'); //gryu+ ѱ ˻  .
		$query = new TextSearchQuery($s); 
		$pages = $dbi->titleSearch($query);
		$lines = array();
		while ($page = $pages->next()) {
			$name =	$page->getName();
			$lines[] = Element('li', LinkExistingWikiWord($name));
			$last_name = $name;
		}

		if ($auto_redirect && count($lines)	== 1)
			$request->redirect(WikiURL($last_name));

		$html =	'';
		if (!$noheader)
			$html .= QElement('p',
							  sprintf("'%s'   ˻ :",	$s)); //gryu*
		if ($lines)
			$html .= Element('ul', join("\n", $lines));
		else
//gryu*
			$html .= '<p>̷ ̸   ϴ.  ̸   ÷  ǥ Ŭϼ: '. LinkUnknownWikiWord($s).'</p>';
		
		return $html;
	}
};
		
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:	  
?>
