<?php
rcs_id('$Id: main.php,v 1.4 2003/06/22 16:11:11 gryu Exp $');
include "lib/stdlib.php";
//include "lib/logger.php";
require_once('lib/Request.php');
require_once("lib/WikiUser.php");
require_once('lib/WikiDB.php');


function deduce_pagename ($request) {
	if ($request->getArg('pagename'))
		return $request->getArg('pagename');
	if (USE_PATH_INFO) {
		$pathinfo = $request->get('PATH_INFO');
		if ( $pathinfo == '' ) echo "Wrong!!!";
		if (ereg('^' . PATH_INFO_PREFIX . '(..*)$', $pathinfo, $m))
			return $m[1];
	}
	$query_string = $request->get('QUERY_STRING');
	if (preg_match('/^[^&=]+$/', $query_string))
		return urldecode($query_string);
	
	return "빮"; //gryu* HomePage -> 빮
}

function is_safe_action ($action) {
	if (! ZIPDUMP_AUTH and ($action == 'zip' || $action == 'xmldump'))
		return true;
	return in_array ( $action, array('browse',
									 'info', 'diff', 'search',
									 'edit', 'save',
									 'login', 'logout',
									 'setprefs', 'random', 'html', 'xml') );
}

function get_auth_mode ($action) {
	switch ($action) {
	case 'logout':
		return  'LOGOUT';
	case 'login':
		return 'LOGIN';
	default:
		if (is_safe_action($action))
			return 'ANON_OK';
		else
			return 'REQUIRE_AUTH';
	}
}

function main ($request) {

	
	if (USE_PATH_INFO && ! $request->get('PATH_INFO')
		&& ! preg_match(',/$,', $request->get('REDIRECT_URL'))) {
		$request->redirect(SERVER_URL
				. preg_replace('/(\?|$)/', '/\1',
				$request->get('REQUEST_URI'),
										  1));
		exit;
	}

	$request->setArg('pagename', deduce_pagename($request));
	global $pagename;               // FIXME: can we make this non-global?
	$pagename = $request->getArg('pagename');
	
	$action = $request->getArg('action');
	if (!$action)
		$action = 'browse';

	global $user;               // FIXME: can we make this non-global?
	$user = new WikiUser($request, get_auth_mode($action));
	//FIXME:
	//if ($user->is_authenticated())
	//  $LogEntry->user = $user->id();

	// All requests require the database
	global $dbi;                // FIXME: can we keep this non-global?
	$dbi = WikiDB::open($GLOBALS['DBParams']);
	
	if ( $action == 'browse' && $request->getArg('pagename') == "빮" ) {
		// if there is no HomePage, create a basic set of Wiki pages
		if ( ! $dbi->isWikiPage("빮") ) {
			include_once("lib/loadsave.php");
			SetupWiki($dbi);
			ExitWiki();
		}
	}

	// FIXME: I think this is redundant.
	if (!is_safe_action($action))
		$user->must_be_admin($action);

	if (isset($DisabledActions) && in_array($action, $DisabledActions))
		ExitWiki(sprintf(gettext("Action %s is disabled in this wiki."), $action));
   
	// Enable the output of most of the warning messages.
	// The warnings will screw up zip files and setpref though.
	if ($action != 'zip' && $action != 'setprefs') {
		global $ErrorManager;
		$ErrorManager->setPostponedErrorMask(E_NOTICE|E_USER_NOTICE);
	}
	
	switch ($action) {
	case 'edit':
		$request->compress_output();
		include "lib/editpage.php";
		editPage($dbi, $request);
		break;

	case 'search':
		$request->compress_output();
		if ($request->getArg('searchtype') == 'full') {
			include "lib/fullsearch.php";
		}
		else {
			include "lib/search.php";
		}
		break;
	  
	case 'save':
		$request->compress_output();
		include "lib/savepage.php";
		savePage($dbi, $request);
		break;
	case 'info':
		$request->compress_output();
		include "lib/pageinfo.php";
		break;
	case 'diff':
		$request->compress_output();
		include_once "lib/diff.php";
		showDiff($dbi, $request);
		break;
	  
	case 'zip':
		include_once("lib/loadsave.php");
		MakeWikiZip($dbi, $request);
		// I don't think it hurts to add cruft at the end of the zip file.
		echo "\n========================================================\n";
		echo "PhpWiki " . PHPWIKI_VERSION . " source:\n$GLOBALS[RCS_IDS]\n";
		break;

	case 'xmldump':
		// FIXME:
		$limit = 1;
		if ($request->getArg('include') == 'all')
			$limit = 0;
		require_once("lib/libxml.php");
		$xmlwriter = new WikiXmlWriter;
		$xmlwriter->begin();
		$xmlwriter->writeComment("PhpWiki " . PHPWIKI_VERSION . " source:\n$RCS_IDS\n");
		$xmlwriter->writeDatabase($dbi, $limit);
		$xmlwriter->end();
		break;
	  
	case 'upload':
		include_once("lib/loadsave.php");
		LoadPostFile($dbi, $request);
		break;
   
	case 'dumpserial':
		include_once("lib/loadsave.php");
		DumpToDir($dbi, $request);
		break;

	case 'loadfile':
		include_once("lib/loadsave.php");
		LoadFileOrDir($dbi, $request);
		break;

	case 'remove':
		include 'admin/removepage.php';
		break;
	
	case 'lock':
	case 'unlock':
		$user->must_be_admin("lock or unlock pages");
		$page = $dbi->getPage($request->getArg('pagename'));
		$page->set('locked', $action == 'lock');

		//$request->compress_output();
		include_once("lib/display.php");
		displayPage($dbi, $request);
		break;

	case 'setprefs':
		$prefs = $user->getPreferences();
		$edit_area_width = $request->getArg('edit_area_width');
		$edit_area_height = $request->getArg('edit_area_height');
		if ($edit_area_width)
			$prefs['edit_area.width'] = $edit_area_width;
		if ($edit_area_height)
			$prefs['edit_area.height'] = $edit_area_height;
		$user->setPreferences($prefs);
		$ErrorManager->setPostponedErrorMask(E_ALL & ~E_NOTICE);

		$request->compress_output();
		include_once("lib/display.php");
		displayPage($dbi, $request);
		break;
//gryu+
	case 'random':
		list($pagename) = $dbi->_backend->GetRandomWikiPageNames(1);
		$request->setArg('pagename', $pagename);
//+gryu		
	case 'browse':
	case 'login':
	case 'logout':
	case 'html':
//		echo "\n"; //gryu+
		//$request->compress_output();
		include_once("lib/display.php");
		displayPage($dbi, $request);
		break;
	case 'xml':
		include_once("lib/output_docbook.php");
		outputDocBook($dbi, $request);
		break;
	default:
		echo QElement('p', sprintf("Bad action: '%s'", urlencode($action)));
		break;
	}
	ExitWiki();
}
$includeBaseUrl = false;
$request = new Request;
main($request);


// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
?>
