/*
 * Decompiled with CFR 0.152.
 */
import com.mybada.docbook.docbook_helper.gui.DisplayPanel;
import com.mybada.docbook.docbook_helper.gui.FileSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class TestFrame
extends JFrame
implements ActionListener,
ErrorListener {
    private FileSelectorPanel fileSelector;
    private JTabbedPane tabs = new JTabbedPane();
    private JTextArea ta = new JTextArea();
    private JTextPane tp = new JTextPane();
    private JTextArea logger = new JTextArea();
    private DisplayPanel displayPanel = new DisplayPanel();

    public TestFrame() {
        this.setTitle("DocBook Converter v0.1");
        this.setSize(300, 500);
        this.setDefaultCloseOperation(3);
        this.fileSelector = new FileSelectorPanel();
        this.getContentPane().add((Component)this.fileSelector, "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JButton transformButton = new JButton("\ubcc0\ud658");
        buttonPanel.add(transformButton);
        transformButton.addActionListener(this);
        mainPanel.add((Component)buttonPanel, "North");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.logger = new JTextArea();
        this.logger.setRows(10);
        JScrollPane loggerScroll = new JScrollPane(this.logger);
        this.getContentPane().add((Component)loggerScroll, "South");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("\ubcc0\ud658")) {
            this.transformIt();
        }
    }

    private String getDefaultOutputFile(String xmlFileName) {
        String headPart = xmlFileName.substring(0, xmlFileName.lastIndexOf(".xml"));
        return headPart + ".html";
    }

    private void transformIt() {
        String outputFileName = this.fileSelector.getOutputFileName();
        String xslFileName = this.fileSelector.getSrcXslFileName();
        String xmlFileName = this.fileSelector.getSrcXmlFileName();
        if (xslFileName.length() == 0 || xmlFileName.length() == 0 || !xslFileName.endsWith(".xsl") || !xmlFileName.endsWith(".xml")) {
            this.logger.append("XML \ubc0f XSL \ud30c\uc77c\uc744 \uc81c\ub300\ub85c \uc120\ud0dd\ud574 \uc8fc\uc138\uc694.\n");
            return;
        }
        if (outputFileName.length() == 0) {
            outputFileName = this.getDefaultOutputFile(xmlFileName);
        }
        try {
            FileWriter outFile = new FileWriter(new File(outputFileName));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(new File(xslFileName)));
            transformer.setErrorListener(this);
            transformer.transform(new StreamSource(new File(xmlFileName)), new StreamResult(outFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.logger.append("\ubcc0\ud658\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n");
    }

    public void error(TransformerException e) {
        this.logger.append(e.toString());
    }

    public void fatalError(TransformerException e) {
        this.logger.append(e.toString());
    }

    public void warning(TransformerException e) {
        this.logger.append(e.toString());
    }

    public static void main(String[] args) {
        TestFrame frame = new TestFrame();
        frame.pack();
        frame.show();
    }
}

