/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.TransliterationRuleSet;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.TransliteratorParser;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.text.UnicodeMatcher;
import com.ibm.icu.text.UnicodeReplacer;
import com.ibm.icu.text.UnicodeSet;
import java.util.Hashtable;

class RuleBasedTransliterator
extends Transliterator {
    private Data data;
    private static final String COPYRIGHT = "\u00a9 IBM Corporation 1999. All rights reserved.";

    public RuleBasedTransliterator(String ID, String rules, int direction, UnicodeFilter filter) {
        super(ID, filter);
        if (direction != 0 && direction != 1) {
            throw new IllegalArgumentException("Invalid direction");
        }
        TransliteratorParser parser = new TransliteratorParser();
        parser.parse(rules, direction);
        if (parser.idBlock.length() != 0 || parser.compoundFilter != null) {
            throw new IllegalArgumentException("::ID blocks illegal in RuleBasedTransliterator constructor");
        }
        this.data = parser.data;
        this.setMaximumContextLength(this.data.ruleSet.getMaximumContextLength());
    }

    public RuleBasedTransliterator(String ID, String rules) {
        this(ID, rules, 0, null);
    }

    RuleBasedTransliterator(String ID, Data data, UnicodeFilter filter) {
        super(ID, filter);
        this.data = data;
        this.setMaximumContextLength(data.ruleSet.getMaximumContextLength());
    }

    protected synchronized void handleTransliterate(Replaceable text, Transliterator.Position index, boolean incremental) {
        int loopCount = 0;
        int loopLimit = index.limit - index.start << 4;
        if (loopLimit < 0) {
            loopLimit = Integer.MAX_VALUE;
        }
        while (index.start < index.limit && loopCount <= loopLimit && this.data.ruleSet.transliterate(text, index, incremental)) {
            ++loopCount;
        }
    }

    public String toRules(boolean escapeUnprintable) {
        return this.data.ruleSet.toRules(escapeUnprintable);
    }

    protected UnicodeSet handleGetSourceSet() {
        return this.data.ruleSet.getSourceTargetSet(false);
    }

    public UnicodeSet getTargetSet() {
        return this.data.ruleSet.getSourceTargetSet(true);
    }

    static class Data {
        public TransliterationRuleSet ruleSet;
        Hashtable variableNames = new Hashtable();
        Object[] variables;
        char variablesBase;

        public Data() {
            this.ruleSet = new TransliterationRuleSet();
        }

        public UnicodeMatcher lookupMatcher(int standIn) {
            int i = standIn - this.variablesBase;
            return i >= 0 && i < this.variables.length ? (UnicodeMatcher)this.variables[i] : null;
        }

        public UnicodeReplacer lookupReplacer(int standIn) {
            int i = standIn - this.variablesBase;
            return i >= 0 && i < this.variables.length ? (UnicodeReplacer)this.variables[i] : null;
        }
    }
}

