/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.ICUResourceBundleImpl;
import com.ibm.icu.impl.ICUResourceBundleIterator;
import com.ibm.icu.impl.ICUResourceBundleReader;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceTypeMismatchException;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class ICUResourceBundle
extends UResourceBundle {
    protected static final String ICU_DATA_PATH = "com/ibm/icu/impl/";
    public static final String ICU_BUNDLE = "data/icudt32b";
    public static final String ICU_BASE_NAME = "com/ibm/icu/impl/data/icudt32b";
    public static final String ICU_COLLATION_BASE_NAME = "com/ibm/icu/impl/data/icudt32b/coll";
    public static final String ICU_RBNF_BASE_NAME = "com/ibm/icu/impl/data/icudt32b/rbnf";
    public static final String ICU_TRANSLIT_BASE_NAME = "com/ibm/icu/impl/data/icudt32b/translit";
    public static final ClassLoader ICU_DATA_CLASS_LOADER = ICUData.class.getClassLoader();
    protected static final String INSTALLED_LOCALES = "InstalledLocales";
    public static final int NONE = -1;
    public static final int STRING = 0;
    public static final int BINARY = 1;
    public static final int TABLE = 2;
    protected static final int ALIAS = 3;
    protected static final int TABLE32 = 4;
    public static final int INT = 7;
    public static final int ARRAY = 8;
    public static final int INT_VECTOR = 14;
    public static final int FROM_FALLBACK = 1;
    public static final int FROM_ROOT = 2;
    public static final int FROM_DEFAULT = 3;
    private int loadingStatus = -1;
    protected int type = -1;
    protected String key;
    protected int size = 1;
    protected String resPath;
    protected long resource = -1L;
    protected boolean isTopLevel = false;
    protected static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    protected static final long RES_BOGUS = -1L;
    private static final String ICU_RESOURCE_INDEX = "res_index";
    private static final String DEFAULT_TAG = "default";
    private static final boolean DEBUG = ICUDebug.enabled("localedata");
    private static SoftReference GET_AVAILABLE_CACHE;

    public void setLoadingStatus(int newStatus) {
        this.loadingStatus = newStatus;
    }

    public int getLoadingStatus() {
        return this.loadingStatus;
    }

    public VersionInfo getVersion() {
        return null;
    }

    public String getString() {
        throw new UResourceTypeMismatchException("");
    }

    public String[] getStringArray() {
        throw new UResourceTypeMismatchException("");
    }

    public ByteBuffer getBinary() {
        throw new UResourceTypeMismatchException("");
    }

    public int[] getIntVector() {
        throw new UResourceTypeMismatchException("");
    }

    public int getInt() {
        throw new UResourceTypeMismatchException("");
    }

    public int getUInt() {
        throw new UResourceTypeMismatchException("");
    }

    public int getSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public ICUResourceBundleIterator getIterator() {
        return new ICUResourceBundleIterator(this);
    }

    public ICUResourceBundle get(int index) {
        ICUResourceBundle obj = this.handleGet(index);
        if (obj == null) {
            obj = (ICUResourceBundle)this.getParent();
            if (obj != null) {
                obj = obj.get(index);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + this.getKey(), this.getClass().getName(), this.getKey());
            }
        }
        return obj;
    }

    public ICUResourceBundle get(String key) {
        ICUResourceBundle obj = this.handleGet(key);
        if (obj == null) {
            obj = (ICUResourceBundle)this.getParent();
            if (obj != null) {
                obj = obj.get(key);
            }
            if (obj == null) {
                String fullName = ICUResourceBundleReader.getFullName(this.getBaseName(), this.getLocaleID());
                throw new MissingResourceException("Can't find resource for bundle " + fullName + ", key " + key, this.getClass().getName(), key);
            }
        }
        return obj;
    }

    public String getString(int index) {
        ICUResourceBundle temp = this.get(index);
        if (temp.getType() == 0) {
            return temp.getString();
        }
        throw new UResourceTypeMismatchException("");
    }

    public abstract UResourceBundle getParent();

    public static final ULocale getFunctionalEquivalent(String baseName, String resName, String keyword, ULocale locID, boolean[] fillinIsAvailable) {
        ICUResourceBundle irb;
        String kwVal = locID.getKeywordValue(keyword);
        String baseLoc = locID.getBaseName();
        String defStr = null;
        ULocale parent = new ULocale(baseLoc);
        ULocale found = locID;
        ULocale defLoc = null;
        boolean lookForDefault = false;
        ULocale fullBase = null;
        int defDepth = 0;
        int resDepth = 0;
        if (fillinIsAvailable != null) {
            fillinIsAvailable[0] = true;
        }
        if (kwVal == null || kwVal.length() == 0 || kwVal.equals(DEFAULT_TAG)) {
            kwVal = "";
            lookForDefault = true;
        }
        ICUResourceBundle r = null;
        r = (ICUResourceBundle)UResourceBundle.getBundleInstance(baseName, parent);
        found = r.getULocale();
        if (fillinIsAvailable != null && !found.equals(parent)) {
            fillinIsAvailable[0] = false;
        }
        do {
            try {
                irb = r.get(resName);
                defStr = irb.getString(DEFAULT_TAG);
                if (lookForDefault) {
                    kwVal = defStr;
                    lookForDefault = false;
                }
                defLoc = r.getULocale();
            }
            catch (MissingResourceException t) {
                // empty catch block
            }
            if (defLoc != null) continue;
            r = (ICUResourceBundle)r.getParent();
            ++defDepth;
        } while (r != null && defLoc == null);
        parent = new ULocale(baseLoc);
        r = (ICUResourceBundle)UResourceBundle.getBundleInstance(baseName, parent);
        do {
            try {
                irb = r.get(resName);
                irb.get(kwVal);
                fullBase = irb.getULocale();
                if (fullBase != null && resDepth > defDepth) {
                    defStr = irb.getString(DEFAULT_TAG);
                    defLoc = r.getULocale();
                    defDepth = resDepth;
                }
            }
            catch (MissingResourceException t) {
                // empty catch block
            }
            if (fullBase != null) continue;
            r = (ICUResourceBundle)r.getParent();
            ++resDepth;
        } while (r != null && fullBase == null);
        if (fullBase == null && defStr != null && !defStr.equals(kwVal)) {
            kwVal = defStr;
            parent = new ULocale(baseLoc);
            r = (ICUResourceBundle)UResourceBundle.getBundleInstance(baseName, parent);
            resDepth = 0;
            do {
                try {
                    irb = r.get(resName);
                    irb.get(kwVal);
                    fullBase = r.getULocale();
                    if (fullBase != null && resDepth > defDepth) {
                        defStr = irb.getString(DEFAULT_TAG);
                        defLoc = r.getULocale();
                        defDepth = resDepth;
                    }
                }
                catch (MissingResourceException t) {
                    // empty catch block
                }
                if (fullBase != null) continue;
                r = (ICUResourceBundle)r.getParent();
                ++resDepth;
            } while (r != null && fullBase == null);
        }
        if (fullBase == null) {
            throw new MissingResourceException("Could not find locale containing requested or default keyword.", baseName, keyword + "=" + kwVal);
        }
        if (defStr.equals(kwVal) && resDepth <= defDepth) {
            return fullBase;
        }
        return new ULocale(fullBase.toString() + "@" + keyword + "=" + kwVal);
    }

    public static final String[] getKeywordValues(String baseName, String keyword) {
        HashSet keywords = new HashSet();
        ULocale[] locales = ICUResourceBundle.createULocaleList(baseName, ICU_DATA_CLASS_LOADER);
        for (int i = 0; i < locales.length; ++i) {
            try {
                UResourceBundle b = UResourceBundle.getBundleInstance(baseName, locales[i]);
                ICUResourceBundle irb = (ICUResourceBundle)b.getObject(keyword);
                Enumeration e = irb.getKeys();
                while (e.hasMoreElements()) {
                    Object s = e.nextElement();
                    if (!(s instanceof String) || DEFAULT_TAG.equals(s)) continue;
                    keywords.add(s);
                }
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return keywords.toArray(new String[0]);
    }

    public ICUResourceBundle getWithFallback(String path) throws MissingResourceException {
        ICUResourceBundle result = null;
        ICUResourceBundle actualBundle = this;
        result = this.findResourceWithFallback(path, actualBundle);
        if (result == null) {
            throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + this.getType(), path, this.getKey());
        }
        return result;
    }

    public String getStringWithFallback(String path) throws MissingResourceException {
        return this.getWithFallback(path).getString();
    }

    public static UResourceBundle getBundleInstance(String baseName, String localeName, boolean disableFallback) {
        return ICUResourceBundle.instantiateBundle(baseName, localeName, ICU_DATA_CLASS_LOADER, disableFallback);
    }

    public static UResourceBundle getBundleInstance(ClassLoader loader, String baseName, String localeName, boolean disableFallback) {
        return ICUResourceBundle.instantiateBundle(baseName, localeName, loader, disableFallback);
    }

    public static Set getAvailableLocaleNameSet(String bundlePrefix) {
        return ICUResourceBundle.getAvailEntry(bundlePrefix).getLocaleNameSet();
    }

    public static Set getFullLocaleNameSet() {
        return ICUResourceBundle.getFullLocaleNameSet(ICU_BASE_NAME);
    }

    public static Set getFullLocaleNameSet(String bundlePrefix) {
        return ICUResourceBundle.getAvailEntry(bundlePrefix).getFullLocaleNameSet();
    }

    public static Set getAvailableLocaleNameSet() {
        return ICUResourceBundle.getAvailableLocaleNameSet(ICU_BASE_NAME);
    }

    public static final ULocale[] getAvailableULocales(String baseName) {
        return ICUResourceBundle.getAvailEntry(baseName).getULocaleList();
    }

    public static final ULocale[] getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales(ICU_BASE_NAME);
    }

    public static final Locale[] getAvailableLocales(String baseName) {
        return ICUResourceBundle.getAvailEntry(baseName).getLocaleList();
    }

    public static final Locale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailEntry(ICU_BASE_NAME).getLocaleList();
    }

    public static final Locale[] getLocaleList(ULocale[] ulocales) {
        ArrayList<Locale> list = new ArrayList<Locale>();
        for (int i = 0; i < ulocales.length; ++i) {
            if (ulocales[i].getScript().length() != 0) continue;
            list.add(ulocales[i].toLocale());
        }
        return list.toArray(new Locale[list.size()]);
    }

    public Enumeration getKeys() {
        Vector<String> keys = new Vector<String>();
        ICUResourceBundle item = null;
        for (int i = 0; i < this.size; ++i) {
            item = this.get(i);
            keys.add(item.getKey());
        }
        return keys.elements();
    }

    public static ICUResourceBundle createBundle(String baseName, String localeID, ClassLoader root) {
        return ICUResourceBundleImpl.createBundle(baseName, localeID, root);
    }

    protected ICUResourceBundle handleGet(String key, HashMap table) {
        throw new UResourceTypeMismatchException("");
    }

    protected ICUResourceBundle handleGet(int index, HashMap table) {
        throw new UResourceTypeMismatchException("");
    }

    public Locale getLocale() {
        return this.getULocale().toLocale();
    }

    protected Object handleGetObject(String key) {
        Object obj = this.handleGetObjectImpl(key);
        if (obj == null) {
            UResourceBundle parent = this.getParent();
            if (parent != null) {
                obj = parent.getObject(key);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + key, this.getClass().getName(), key);
            }
        }
        return obj;
    }

    private Object handleGetObjectImpl(String key) {
        if (this.getType() == 0) {
            return this.getString();
        }
        ICUResourceBundle obj = this.handleGet(key);
        if (obj != null) {
            if (obj.getType() == 0) {
                return obj.getString();
            }
            try {
                if (obj.getType() == 8) {
                    return obj.handleGetStringArray();
                }
            }
            catch (UResourceTypeMismatchException ex) {
                return obj;
            }
        }
        return obj;
    }

    protected ICUResourceBundle handleGet(int index) {
        return null;
    }

    protected ICUResourceBundle handleGet(String key) {
        return null;
    }

    protected String[] handleGetStringArray() {
        return null;
    }

    private static final ULocale[] createULocaleList(String baseName, ClassLoader root) {
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.instantiateBundle(baseName, ICU_RESOURCE_INDEX, root, true);
        bundle = bundle.get(INSTALLED_LOCALES);
        int length = bundle.getSize();
        int i = 0;
        ULocale[] locales = new ULocale[length];
        ICUResourceBundleIterator iter = bundle.getIterator();
        iter.reset();
        while (iter.hasNext()) {
            locales[i++] = new ULocale(iter.next().getKey());
        }
        bundle = null;
        return locales;
    }

    private static final Locale[] createLocaleList(String baseName) {
        ULocale[] ulocales = ICUResourceBundle.getAvailEntry(baseName).getULocaleList();
        return ICUResourceBundle.getLocaleList(ulocales);
    }

    private static final String[] createLocaleNameArray(String baseName, ClassLoader root) {
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.instantiateBundle(baseName, ICU_RESOURCE_INDEX, root, true);
        bundle = bundle.get(INSTALLED_LOCALES);
        int length = bundle.getSize();
        int i = 0;
        String[] locales = new String[length];
        ICUResourceBundleIterator iter = bundle.getIterator();
        iter.reset();
        while (iter.hasNext()) {
            locales[i++] = iter.next().getKey();
        }
        bundle = null;
        return locales;
    }

    private static final ArrayList createFullLocaleNameArray(final String baseName, final ClassLoader root) {
        final ArrayList list = new ArrayList();
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object run() {
                URL url = root.getResource(baseName);
                if (!url.getProtocol().equalsIgnoreCase("jar")) {
                    File file = new File(url.getPath());
                    File[] files = file.listFiles();
                    if (files == null) return null;
                    for (int i = 0; i < files.length; ++i) {
                        String name;
                        if (files[i].isDirectory() || (name = files[i].getName()).indexOf(ICUResourceBundle.ICU_RESOURCE_INDEX) >= 0) continue;
                        name = name.substring(0, name.lastIndexOf(46));
                        list.add(name);
                    }
                    return null;
                } else {
                    try {
                        String fileName = url.getPath();
                        int ix = fileName.indexOf("!/");
                        if (ix >= 0) {
                            fileName = fileName.substring(ix + 2);
                        }
                        JarURLConnection conn = (JarURLConnection)url.openConnection();
                        JarFile jarFile = conn.getJarFile();
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            String name;
                            JarEntry entry = entries.nextElement();
                            if (entry.isDirectory() || !(name = entry.getName()).startsWith(fileName) || (name = name.substring(fileName.length() + 1)).indexOf(47) != -1 || !name.endsWith(".res")) continue;
                            name = name.substring(0, name.lastIndexOf(46));
                            list.add(name);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        if (!DEBUG) return null;
                        System.out.println("icurb jar error: " + e);
                        Thread.dumpStack();
                    }
                }
                return null;
            }
        });
        return list;
    }

    private static Set createFullLocaleNameSet(String baseName) {
        ArrayList list = ICUResourceBundle.createFullLocaleNameArray(baseName, ICU_DATA_CLASS_LOADER);
        HashSet set = new HashSet();
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static Set createLocaleNameSet(String baseName) {
        try {
            String[] locales = ICUResourceBundle.createLocaleNameArray(baseName, ICU_DATA_CLASS_LOADER);
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(locales));
            return Collections.unmodifiableSet(set);
        }
        catch (MissingResourceException e) {
            if (DEBUG) {
                System.out.println("couldn't find index for bundleName: " + baseName);
                Thread.dumpStack();
            }
            return Collections.EMPTY_SET;
        }
    }

    private static AvailEntry getAvailEntry(String key) {
        AvailEntry ae = null;
        HashMap<String, AvailEntry> lcache = null;
        if (GET_AVAILABLE_CACHE != null && (lcache = (HashMap<String, AvailEntry>)GET_AVAILABLE_CACHE.get()) != null) {
            ae = (AvailEntry)lcache.get(key);
        }
        if (ae == null) {
            ae = new AvailEntry(key);
            if (lcache == null) {
                lcache = new HashMap<String, AvailEntry>();
                lcache.put(key, ae);
                GET_AVAILABLE_CACHE = new SoftReference(lcache);
            } else {
                lcache.put(key, ae);
            }
        }
        return ae;
    }

    private ICUResourceBundle findResourceWithFallback(String path, ICUResourceBundle actualBundle) {
        ICUResourceBundle sub = null;
        while (actualBundle != null) {
            String subKey;
            StringTokenizer st = new StringTokenizer(path, "/");
            ICUResourceBundle current = actualBundle;
            while (st.hasMoreTokens() && (sub = current.handleGet(subKey = st.nextToken(), null)) != null) {
                current = sub;
            }
            if (sub != null) break;
            if (actualBundle.resPath.length() != 0) {
                path = this.resPath + "/" + path;
            }
            actualBundle = (ICUResourceBundle)actualBundle.getParent();
        }
        return sub;
    }

    public boolean equals(Object other) {
        if (other instanceof ICUResourceBundle) {
            ICUResourceBundle o = (ICUResourceBundle)other;
            if (this.getBaseName().equals(o.getBaseName()) && this.getULocale().equals(o.getULocale())) {
                return true;
            }
        }
        return false;
    }

    private static final class AvailEntry {
        private String prefix;
        private ULocale[] ulocales;
        private Locale[] locales;
        private Set nameSet;
        private Set fullNameSet;

        AvailEntry(String prefix) {
            this.prefix = prefix;
        }

        ULocale[] getULocaleList() {
            if (this.ulocales == null) {
                this.ulocales = ICUResourceBundle.createULocaleList(this.prefix, ICU_DATA_CLASS_LOADER);
            }
            return this.ulocales;
        }

        Locale[] getLocaleList() {
            if (this.locales == null) {
                this.locales = ICUResourceBundle.createLocaleList(this.prefix);
            }
            return this.locales;
        }

        Set getLocaleNameSet() {
            if (this.nameSet == null) {
                this.nameSet = ICUResourceBundle.createLocaleNameSet(this.prefix);
            }
            return this.nameSet;
        }

        Set getFullLocaleNameSet() {
            if (this.fullNameSet == null) {
                this.fullNameSet = ICUResourceBundle.createFullLocaleNameSet(this.prefix);
            }
            return this.fullNameSet;
        }
    }
}

