/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.xpath.StandaloneContext;
import net.sf.saxon.xpath.XPathException;
import net.sf.saxon.xpath.XPathExpression;

public class XPathEvaluator {
    private NodeInfo contextNode = null;
    private StaticContext staticContext;
    private boolean stripSpace = false;

    public XPathEvaluator() {
    }

    public XPathEvaluator(Source source) throws XPathException {
        this.setSource(source);
    }

    public void setStripSpace(boolean bl) {
        this.stripSpace = bl;
    }

    public NodeInfo setSource(Source source) throws XPathException {
        NamePool namePool = source instanceof NodeInfo ? ((NodeInfo)source).getNamePool() : NamePool.getDefaultNamePool();
        AllElementStripper allElementStripper = null;
        if (this.stripSpace) {
            allElementStripper = AllElementStripper.getInstance();
        }
        Configuration configuration = new Configuration();
        configuration.setNamePool(namePool);
        this.contextNode = Builder.build(source, allElementStripper, configuration);
        this.staticContext = new StandaloneContext(configuration);
        return this.contextNode;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public XPathExpression createExpression(String string) throws XPathException {
        Expression expression = ExpressionTool.make(string, this.staticContext, 0, -1, 1);
        expression = expression.analyze(this.staticContext, Type.ITEM_TYPE);
        SlotManager slotManager = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expression, 1, null);
        XPathExpression xPathExpression = new XPathExpression(expression, this.staticContext.getConfiguration());
        xPathExpression.setStackFrameMap(slotManager);
        xPathExpression.setContextNode(this.contextNode);
        return xPathExpression;
    }

    public void setContextNode(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        this.contextNode = nodeInfo;
    }

    public List evaluate(String string) throws XPathException {
        Expression expression = ExpressionTool.make(string, this.staticContext, 0, -1, 1);
        expression = expression.analyze(this.staticContext, Type.ITEM_TYPE);
        SlotManager slotManager = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expression, 1, slotManager);
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.contextNode, this.staticContext.getConfiguration());
        xPathContextMajor.openStackFrame(slotManager);
        SequenceIterator sequenceIterator = expression.iterate(xPathContextMajor);
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        Item item;
        while ((item = sequenceIterator.next()) != null) {
            arrayList.add(XPathEvaluator.convert(item));
        }
        return arrayList;
    }

    public static Object convert(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            Object object = item;
            while (object instanceof VirtualNode) {
                object = ((VirtualNode)object).getUnderlyingNode();
            }
            return object;
        }
        switch (((AtomicValue)item).getItemType().getPrimitiveType()) {
            case 513: 
            case 518: 
            case 529: 
            case 642: {
                return item.getStringValue();
            }
            case 514: {
                return ((BooleanValue)item).getBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 515: {
                return ((DecimalValue)item).getValue();
            }
            case 532: {
                return new Long(((NumericValue)item).longValue());
            }
            case 517: {
                return new Double(((DoubleValue)item).getDoubleValue());
            }
            case 516: {
                return new Float(((FloatValue)item).getValue());
            }
            case 519: {
                return ((DateTimeValue)item).getUTCDate();
            }
            case 521: {
                return ((DateValue)item).getUTCDate();
            }
            case 520: {
                return item.getStringValue();
            }
            case 528: {
                return ((Base64BinaryValue)item).getBinaryValue();
            }
            case 527: {
                return ((HexBinaryValue)item).getBinaryValue();
            }
        }
        return item;
    }

    public Object evaluateSingle(String string) throws XPathException {
        Expression expression = ExpressionTool.make(string, this.staticContext, 0, -1, 1);
        expression = expression.analyze(this.staticContext, Type.ITEM_TYPE);
        SlotManager slotManager = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expression, 1, slotManager);
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.contextNode, this.staticContext.getConfiguration());
        xPathContextMajor.openStackFrame(slotManager);
        SequenceIterator sequenceIterator = expression.iterate(xPathContextMajor);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        return XPathEvaluator.convert(item);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.err.println("format: java XPathEvaluator source.xml \"expression\"");
            System.exit(2);
        }
        XPathEvaluator xPathEvaluator = new XPathEvaluator(new StreamSource(new File(stringArray[0])));
        List list = xPathEvaluator.evaluate(stringArray[1]);
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            System.err.println(e);
            ++n;
        }
    }
}

