/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class GYearMonthValue
extends DateValue {
    private static Pattern regex = Pattern.compile("(-?[0-9]+-[0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    public GYearMonthValue() {
    }

    public GYearMonthValue(CharSequence charSequence) throws XPathException {
        Matcher matcher = regex.matcher(charSequence);
        if (!matcher.matches()) {
            throw new DynamicError("Cannot convert '" + charSequence + "' to a gYearMonth");
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        String string3 = string + "-01" + (string2 == null ? "" : string2);
        this.setLexicalValue(string3);
    }

    public ItemType getItemType() {
        return Type.G_YEAR_MONTH_TYPE;
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        switch (n) {
            case 88: 
            case 522: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        DynamicError dynamicError = new DynamicError("Cannot convert gYearMonth to " + StandardNames.getDisplayName(n));
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.calendar.get(0);
        int n2 = this.calendar.get(1);
        if (n == 0) {
            stringBuffer.append('-');
        }
        DateTimeValue.appendString(stringBuffer, n2, n2 > 9999 ? (this.calendar.get(1) + "").length() : 4);
        stringBuffer.append('-');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(2) + 1, 2);
        if (this.zoneSpecified) {
            DateTimeValue.appendTimezone(this.tzOffset, stringBuffer);
        }
        return stringBuffer.toString();
    }
}

