/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class DecimalValue
extends NumericValue {
    private static final int DIVIDE_PRECISION = 18;
    private BigDecimal value;
    private static Pattern decimalPattern = Pattern.compile("(\\-|\\+)?((\\.[0-9]+)|([0-9]+(\\.[0-9]*)?))");
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$net$sf$saxon$value$DecimalValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    public DecimalValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
        this.loseTrailingZeros();
    }

    public DecimalValue(CharSequence charSequence) throws XPathException {
        String string = Value.trimWhitespace(charSequence).toString();
        try {
            if (!decimalPattern.matcher(string).matches()) {
                DynamicError dynamicError = new DynamicError("Cannot convert string " + Err.wrap(string, 4) + " to decimal");
                dynamicError.setErrorCode("FORG0001");
                throw dynamicError;
            }
            this.value = new BigDecimal(string);
            if (string.charAt(string.length() - 1) == '0') {
                this.loseTrailingZeros();
            }
        }
        catch (NumberFormatException numberFormatException) {
            DynamicError dynamicError = new DynamicError("Cannot convert string " + Err.wrap(string, 4) + " to decimal");
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
    }

    public DecimalValue(double d) throws XPathException {
        try {
            this.value = new BigDecimal(d);
            this.loseTrailingZeros();
        }
        catch (NumberFormatException numberFormatException) {
            DynamicError dynamicError = new DynamicError("Cannot convert double " + Err.wrap(d + "", 4) + " to decimal");
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
    }

    public DecimalValue(long l) {
        this.value = new BigDecimal((double)l);
    }

    /*
     * Unable to fully structure code
     */
    private void loseTrailingZeros() {
        block1: {
            if (this.value.scale() <= 0) break block1;
            var1_1 = this.value.toString();
            if (var1_1.charAt((var2_2 = var1_1.length()) - 1) == '0') ** GOTO lbl6
            return;
lbl-1000:
            // 1 sources

            {
                --var2_2;
lbl6:
                // 2 sources

                ** while (var1_1.charAt((int)(var2_2 - 1)) == '0')
            }
lbl7:
            // 1 sources

            this.value = new BigDecimal(var1_1.substring(0, var2_2));
        }
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public int hashCode() {
        BigDecimal bigDecimal = this.value.setScale(0, 1);
        long l = bigDecimal.longValue();
        if (l > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
            return (int)l;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value.signum() != 0;
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        switch (n) {
            case 514: {
                return BooleanValue.get(this.value.signum() != 0);
            }
            case 88: 
            case 515: 
            case 643: 
            case 646: {
                return this;
            }
            case 532: {
                return BigIntegerValue.makeValue(this.value.toBigInteger());
            }
            case 517: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 516: {
                return new FloatValue(this.value.floatValue());
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        DynamicError dynamicError = new DynamicError("Cannot convert decimal to " + StandardNames.getDisplayName(n));
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public String getStringValue() {
        String string = this.value.toString();
        return string;
    }

    public ItemType getItemType() {
        return Type.DECIMAL_TYPE;
    }

    public NumericValue negate() {
        return new DecimalValue(this.value.negate());
    }

    public NumericValue floor() {
        return new DecimalValue(this.value.setScale(0, 3));
    }

    public NumericValue ceiling() {
        return new DecimalValue(this.value.setScale(0, 2));
    }

    public NumericValue round() {
        switch (this.value.signum()) {
            case -1: {
                return new DecimalValue(this.value.setScale(0, 5));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new DecimalValue(this.value.setScale(0, 4));
            }
        }
        return this;
    }

    public NumericValue roundToHalfEven(int n) {
        if (n < 0) {
            try {
                AtomicValue atomicValue = this.convert(532, null);
                if (atomicValue instanceof IntegerValue) {
                    return ((IntegerValue)atomicValue).roundToHalfEven(n);
                }
                return ((BigIntegerValue)atomicValue).roundToHalfEven(n);
            }
            catch (XPathException xPathException) {
                throw new IllegalArgumentException("internal error in integer-decimal conversion");
            }
        }
        return new DecimalValue(this.value.setScale(n, 6));
    }

    public boolean isWholeNumber() {
        return this.value.scale() == 0 || this.value.equals(this.value.setScale(0, 1));
    }

    public NumericValue arithmetic(int n, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof DecimalValue) {
            try {
                switch (n) {
                    case 15: {
                        return new DecimalValue(this.value.add(((DecimalValue)numericValue).value));
                    }
                    case 16: {
                        return new DecimalValue(this.value.subtract(((DecimalValue)numericValue).value));
                    }
                    case 17: {
                        return new DecimalValue(this.value.multiply(((DecimalValue)numericValue).value));
                    }
                    case 18: {
                        int n2 = Math.max(18, Math.max(this.value.scale(), ((DecimalValue)numericValue).value.scale()));
                        BigDecimal bigDecimal = this.value.divide(((DecimalValue)numericValue).value, n2, 5);
                        return new DecimalValue(bigDecimal);
                    }
                    case 50: {
                        BigInteger bigInteger = this.value.divide(((DecimalValue)numericValue).value, 0, 1).toBigInteger();
                        return BigIntegerValue.makeValue(bigInteger);
                    }
                    case 19: {
                        BigDecimal bigDecimal = this.value.divide(((DecimalValue)numericValue).value, 0, 1);
                        BigDecimal bigDecimal2 = this.value.subtract(bigDecimal.multiply(((DecimalValue)numericValue).value));
                        return new DecimalValue(bigDecimal2);
                    }
                }
                throw new AssertionError((Object)"Unknown operator");
            }
            catch (ArithmeticException arithmeticException) {
                throw new DynamicError(arithmeticException);
            }
        }
        if (NumericValue.isInteger(numericValue)) {
            return this.arithmetic(n, (DecimalValue)numericValue.convert(515, xPathContext), xPathContext);
        }
        NumericValue numericValue2 = (NumericValue)this.convert(numericValue.getItemType().getPrimitiveType(), xPathContext);
        return numericValue2.arithmetic(n, numericValue, xPathContext);
    }

    public int compareTo(Object object) {
        if (NumericValue.isInteger((NumericValue)object)) {
            try {
                return this.compareTo(((NumericValue)object).convert(515, null));
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"Conversion of integer to decimal should never fail");
            }
        }
        if (object instanceof BigIntegerValue) {
            return this.value.compareTo(((BigIntegerValue)object).asDecimal());
        }
        if (object instanceof DecimalValue) {
            return this.value.compareTo(((DecimalValue)object).value);
        }
        return super.compareTo(object);
    }

    public Object convertToJava(Class clazz, Configuration configuration, XPathContext xPathContext) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DecimalValue.class$("java.lang.Object")) : class$java$lang$Object) || clazz.isAssignableFrom(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DecimalValue.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return this.value;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DecimalValue == null ? (class$net$sf$saxon$value$DecimalValue = DecimalValue.class$("net.sf.saxon.value.DecimalValue")) : class$net$sf$saxon$value$DecimalValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, null);
            return booleanValue.getBooleanValue();
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = DecimalValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, null);
            return booleanValue.getBooleanValue();
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DecimalValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DecimalValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = DecimalValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value.doubleValue());
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = DecimalValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value.floatValue());
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = DecimalValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(this.value.longValue());
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = DecimalValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(this.value.intValue());
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = DecimalValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(this.value.shortValue());
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = DecimalValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte(this.value.byteValue());
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = DecimalValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character((char)this.value.intValue());
        }
        Object object = super.convertToJava(clazz, configuration, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of decimal to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

