/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TypeInfo;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.xpath.XPathException;

public abstract class SchemaType
implements TypeInfo,
Serializable,
SourceLocator {
    protected int finalProhibitions = 0;
    public static final int DERIVATION_RESTRICTION = 1;
    public static final int DERIVATION_EXTENSION = 2;
    public static final int DERIVATION_UNION = 4;
    public static final int DERIVATION_LIST = 8;
    public static final int DERIVE_BY_SUBSTITUTION = 16;
    private String localName = null;
    private int baseTypeFingerprint = -1;
    private SchemaType baseType = null;
    private int containingDeclarationName = -1;
    private boolean containingDeclarationIsElement = true;
    private NamePool namePool = null;
    private int derivation = 0;
    private int fingerprint = -1;
    private String systemId = null;
    private int lineNumber = -1;
    protected int validationPhase = 0;
    public static final int UNVALIDATED = 0;
    public static final int VALIDATING = 1;
    public static final int VALIDATED = 2;
    public static final int INVALID = 3;

    public int getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(int n) {
        this.fingerprint = n;
    }

    public int getBaseTypeFingerprint() {
        if (this.baseTypeFingerprint == -1 && this.baseType != null) {
            this.baseTypeFingerprint = this.baseType.getFingerprint();
        }
        return this.baseTypeFingerprint;
    }

    public void setBaseTypeFingerprint(int n) {
        this.baseTypeFingerprint = n;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public String getDisplayName() {
        return this.namePool.getDisplayName(this.fingerprint);
    }

    public String getTypeName() {
        return this.namePool.getLocalName(this.fingerprint);
    }

    public String getTypeNamespace() {
        return this.namePool.getURI(this.fingerprint);
    }

    public final boolean isComplexType() {
        return !this.isSimpleType();
    }

    public abstract boolean isSimpleType();

    public int getBlock() {
        return 0;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public SchemaType getBaseType() {
        return this.baseType;
    }

    public void setBaseType(SchemaType schemaType) throws SchemaException {
        this.baseType = schemaType;
    }

    public int getDerivationMethod() {
        return this.derivation;
    }

    public boolean allowsDerivation(int n) {
        return (this.finalProhibitions & n) == 0;
    }

    public void setDerivationMethodName(String string) throws SchemaException {
        if (string.equals("restriction")) {
            this.derivation = 1;
        } else if (string.equals("union")) {
            this.derivation = 4;
        } else if (string.equals("list")) {
            this.derivation = 8;
        } else if (string.equals("extension")) {
            this.derivation = 2;
        } else {
            throw new SchemaException("Unknown derivation method: " + string);
        }
    }

    public void setDerivationMethod(int n) {
        this.derivation = n;
    }

    public void setFinalProhibitions(int n) {
        this.finalProhibitions = n;
    }

    public void checkDerivation(SchemaType schemaType, int n) throws SchemaException {
        int n2 = 0;
        SchemaType schemaType2 = this;
        while (true) {
            if (schemaType2 == null) {
                if (schemaType instanceof AnyType) {
                    return;
                }
                throw new SchemaException("The requested type " + this.getDescription() + " is not derived from the declared type " + schemaType.getDescription());
            }
            if ((n2 & schemaType2.getBlock()) != 0) {
                throw new SchemaException("Derivation of the requested type " + this.getDescription() + " is blocked by the base type " + schemaType2.getDescription());
            }
            if (schemaType2 == schemaType) break;
            n2 |= schemaType2.getDerivationMethod();
            schemaType2 = schemaType2.getBaseType();
        }
        if ((n2 & n) != 0) {
            throw new SchemaException("Derivation of the requested type " + this.getDescription() + " is blocked by the element declaration");
        }
    }

    public boolean isDerivedFrom(String string, String string2, int n) {
        SchemaType schemaType = this.getBaseType();
        if (n == 0 || (n & this.getDerivationMethod()) != 0) {
            if (schemaType.getTypeName().equals(string2) && schemaType.getTypeNamespace().equals(string)) {
                return true;
            }
            if (schemaType instanceof AnyType) {
                return false;
            }
            return schemaType.isDerivedFrom(string, string2, n);
        }
        return false;
    }

    public abstract SequenceIterator getTypedValue(NodeInfo var1) throws XPathException;

    public void setContainingDeclaration(int n, boolean bl) {
        this.containingDeclarationName = n;
        this.containingDeclarationIsElement = bl;
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.systemId = sourceLocator.getSystemId();
        this.lineNumber = sourceLocator.getLineNumber();
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public abstract int relationshipTo(SchemaType var1);

    public String getDescription() {
        int n = this.getFingerprint();
        NamePool namePool = this.getNamePool();
        if (n != -1 && namePool.getURI(n) != "http://ns.saxonica.com/anonymous-type") {
            return namePool.getDisplayName(n);
        }
        if (this.containingDeclarationName != -1) {
            return "of " + (this.containingDeclarationIsElement ? "element " : "attribute ") + namePool.getDisplayName(this.containingDeclarationName);
        }
        return "defined at line " + this.getLineNumber() + " of " + this.getSystemId();
    }

    public int getContainingDeclarationName() {
        return this.containingDeclarationName;
    }

    public boolean containingDeclarationIsElement() {
        return this.containingDeclarationIsElement;
    }
}

