/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.xpath.XPathException;

final class TinyNamespaceImpl
extends TinyNodeImpl {
    private int parentNode;
    private int nameCode;

    public TinyNamespaceImpl(TinyDocumentImpl tinyDocumentImpl, int n) {
        this.document = tinyDocumentImpl;
        this.nodeNr = n;
        this.nameCode = this.document.getNamePool().allocate("", "", this.getLocalPart());
    }

    public int getNamespaceCode() {
        return this.document.namespaceCode[this.nodeNr];
    }

    public int getFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    protected void setParentNode(int n) {
        this.parentNode = n;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public String getPrefix() {
        return null;
    }

    public String getDisplayName() {
        return this.getLocalPart();
    }

    public String getLocalPart() {
        return this.document.getNamePool().getPrefixFromNamespaceCode(this.document.namespaceCode[this.nodeNr]);
    }

    public String getURI() {
        return "";
    }

    public NodeInfo getParent() {
        return this.document.getNode(this.parentNode);
    }

    public final boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof TinyNamespaceImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        TinyNamespaceImpl tinyNamespaceImpl = (TinyNamespaceImpl)nodeInfo;
        return this.parentNode == ((TinyNamespaceImpl)nodeInfo).parentNode && this.document == tinyNamespaceImpl.document && this.nodeNr == ((TinyNamespaceImpl)nodeInfo).nodeNr;
    }

    public final int getNodeKind() {
        return 13;
    }

    public final String getStringValue() {
        return this.document.getNamePool().getURIFromNamespaceCode(this.document.namespaceCode[this.nodeNr]);
    }

    public String getBaseURI() {
        return null;
    }

    public String generateId() {
        return this.getParent().generateId() + "n" + this.getNameCode();
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        receiver.namespace(this.getNamespaceCode(), 32);
    }

    protected long getSequenceNumber() {
        return ((TinyNodeImpl)this.getParent()).getSequenceNumber() + (long)this.nodeNr + 1L;
    }
}

