/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class XSLTemplate
extends StyleElement
implements StylesheetProcedure {
    private String matchAtt = null;
    private String modeAtt = null;
    private String nameAtt = null;
    private String priorityAtt = null;
    private String asAtt = null;
    private int[] modeNameCodes;
    private String diagnosticId;
    private Pattern match;
    private boolean prioritySpecified;
    private double priority;
    private SlotManager stackFrameMap;
    private Template compiledTemplate = new Template();
    private SequenceType requiredType = null;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public int getTemplateFingerprint() {
        try {
            String string;
            if (this.getObjectFingerprint() == -1 && (string = this.getAttributeValue("name")) != null) {
                this.setObjectNameCode(this.makeNameCode(string.trim()));
            }
            return this.getObjectFingerprint();
        }
        catch (NamespaceException namespaceException) {
            return -1;
        }
        catch (XPathException xPathException) {
            return -1;
        }
    }

    protected ItemType getReturnedItemType() {
        if (this.requiredType == null) {
            return this.getCommonChildItemType();
        }
        return this.requiredType.getPrimaryType();
    }

    private int getMinImportPrecedence() {
        return ((XSLStylesheet)this.getDocumentElement()).getMinImportPrecedence();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n2 = 0;
        while (n2 < attributeCollection.getLength()) {
            n = attributeCollection.getNameCode(n2);
            String string = this.getNamePool().getClarkName(n);
            if (string == "mode") {
                this.modeAtt = attributeCollection.getValue(n2).trim();
            } else if (string == "name") {
                this.nameAtt = attributeCollection.getValue(n2).trim();
            } else if (string == "match") {
                this.matchAtt = attributeCollection.getValue(n2);
            } else if (string == "priority") {
                this.priorityAtt = attributeCollection.getValue(n2).trim();
            } else if (string == "as") {
                this.asAtt = attributeCollection.getValue(n2);
            } else {
                this.checkUnknownAttribute(n);
            }
            ++n2;
        }
        try {
            if (this.modeAtt == null) {
                this.modeNameCodes = new int[1];
                this.modeNameCodes[0] = -1;
            } else {
                if (this.matchAtt == null) {
                    this.compileError("The mode attribute must be absent if the match attribute is absent");
                }
                n = 0;
                boolean bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(this.modeAtt);
                while (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    ++n;
                }
                if (n == 0) {
                    this.compileError("The mode attribute must not be empty");
                }
                this.modeNameCodes = new int[n];
                n = 0;
                stringTokenizer = new StringTokenizer(this.modeAtt);
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if ("#default".equals(string)) {
                        this.modeNameCodes[n++] = -1;
                        continue;
                    }
                    if ("#all".equals(string)) {
                        bl = true;
                        this.modeNameCodes[n++] = -2;
                        continue;
                    }
                    this.modeNameCodes[n++] = this.makeNameCode(string);
                }
                if (bl && n > 1) {
                    this.compileError("mode='#all' cannot be combined with other modes", "XT0550");
                }
            }
            if (this.nameAtt != null) {
                this.setObjectNameCode(this.makeNameCode(this.nameAtt.trim()));
                this.diagnosticId = this.nameAtt;
            }
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
        }
        boolean bl = this.prioritySpecified = this.priorityAtt != null;
        if (this.prioritySpecified) {
            if (this.matchAtt == null) {
                this.compileError("The priority attribute must be absent if the match attribute is absent");
            }
            try {
                this.priority = Double.parseDouble(this.priorityAtt.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XT0530");
            }
        }
        if (this.matchAtt != null) {
            this.match = this.makePattern(this.matchAtt);
            if (this.diagnosticId == null) {
                this.diagnosticId = "match=\"" + this.matchAtt + '\"';
            }
        }
        if (this.match == null && this.nameAtt == null) {
            this.compileError("xsl:template must have a name or match attribute (or both)");
        }
        if (this.asAtt != null) {
            this.requiredType = this.makeSequenceType(this.asAtt);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        if (this.match != null) {
            this.typeCheck("match", this.match);
            if (this.match.getNodeTest() instanceof NoNodeTest) {
                try {
                    this.getConfiguration().getErrorListener().warning(new TransformerException("Match pattern does not match any nodes", this));
                }
                catch (TransformerException transformerException) {
                    this.compileError(transformerException);
                }
            }
        }
        this.markTailCalls();
    }

    public void markTailCalls() {
        StyleElement styleElement;
        if (this.requiredType == null && (styleElement = this.getLastChildInstruction()) != null) {
            styleElement.markTailCalls();
        }
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        Object object;
        Object object2;
        Block block = new Block();
        this.compileChildren(executable, block, true);
        Object object3 = null;
        try {
            object3 = block.simplify(this.getStaticContext());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        try {
            if (this.requiredType != null) {
                object2 = new RoleLocator(7, this.diagnosticId, 0);
                object3 = TypeChecker.staticTypeCheck((Expression)object3, this.requiredType, false, (RoleLocator)object2, this.getStaticContext());
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        this.compiledTemplate.init(this.getObjectFingerprint(), this.getPrecedence(), this.getMinImportPrecedence());
        if (this.getConfiguration().getTraceListener() != null) {
            object2 = new TraceInstruction((Expression)object3, this);
            ((ComputedExpression)object2).setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            ((ComputedExpression)object2).setParentExpression(this.compiledTemplate);
            object3 = object2;
        }
        this.compiledTemplate.setBody((Expression)object3);
        this.compiledTemplate.setStackFrameMap(this.stackFrameMap);
        this.compiledTemplate.setExecutable(this.getExecutable());
        this.compiledTemplate.setSystemId(this.getSystemId());
        this.compiledTemplate.setLineNumber(this.getLineNumber());
        object2 = Type.ITEM_TYPE;
        if (this.getObjectFingerprint() == -1) {
            object2 = this.match.getNodeTest();
        }
        try {
            object = object3.analyze(this.staticContext, (ItemType)object2);
            if (object3 != object) {
                this.compiledTemplate.setBody((Expression)object);
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        super.allocateSlots((Expression)object3);
        if (this.match != null) {
            object = this.getPrincipalStylesheet().getRuleManager();
            int n = 0;
            while (n < this.modeNameCodes.length) {
                int n2 = this.modeNameCodes[n];
                Mode mode = ((RuleManager)object).getMode(n2);
                if (n2 != -1 && n2 != -2) {
                    mode.setModeNameCode(n2);
                }
                if (this.prioritySpecified) {
                    ((RuleManager)object).setHandler(this.match, this.compiledTemplate, mode, this.getPrecedence(), this.priority);
                } else {
                    ((RuleManager)object).setHandler(this.match, this.compiledTemplate, mode, this.getPrecedence());
                }
                ++n;
            }
        }
        return null;
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public void allocateSlots(Expression expression) {
        int n = ExpressionTool.allocateSlots(expression, 0, null);
        this.getContainingStylesheet().allocatePatternSlots(n);
    }

    public Template getCompiledTemplate() {
        return this.compiledTemplate;
    }

    public int getConstructType() {
        return 181;
    }
}

