/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.xpath.XPathException;

public class XSLCharacterMap
extends StyleElement {
    String use;
    List characterMapElements = null;
    boolean validated = false;
    boolean redundant = false;

    public int getCharacterMapFingerprint() {
        return this.getObjectNameCode() & 0xFFFFF;
    }

    public boolean isRedundant() {
        return this.redundant;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        this.use = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "name") {
                string = attributeCollection.getValue(n).trim();
            } else if (string2 == "use-character-maps") {
                this.use = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.setObjectNameCode(this.makeNameCode(string.trim()));
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
        }
    }

    public void validate() throws TransformerConfigurationException {
        Item item;
        if (this.validated) {
            return;
        }
        this.checkTopLevel(null);
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((item = axisIterator.next()) != null) {
            if (item instanceof XSLOutputCharacter) continue;
            this.compileError("Only xsl:output-character is allowed within xsl:character-map");
        }
        item = this.getPrincipalStylesheet();
        XSLCharacterMap xSLCharacterMap = ((XSLStylesheet)item).getCharacterMap(this.getObjectFingerprint());
        if (xSLCharacterMap != this) {
            if (this.getPrecedence() == xSLCharacterMap.getPrecedence()) {
                this.compileError("There are two character-maps with the same name and import precedence");
            } else if (this.getPrecedence() < xSLCharacterMap.getPrecedence()) {
                this.redundant = true;
            }
        }
        if (this.use != null) {
            Object object;
            this.characterMapElements = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(this.use);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                try {
                    String[] stringArray = Name.getQNameParts((CharSequence)object);
                    String string = this.getURIForPrefix(stringArray[0], false);
                    int n = this.getTargetNamePool().allocate(stringArray[0], string, stringArray[1]);
                    XSLCharacterMap xSLCharacterMap2 = ((XSLStylesheet)item).getCharacterMap(n & 0xFFFFF);
                    if (xSLCharacterMap2 == null) {
                        this.compileError("No character-map named '" + (String)object + "' has been defined");
                        continue;
                    }
                    this.characterMapElements.add(xSLCharacterMap2);
                }
                catch (QNameException qNameException) {
                    this.compileError("Invalid character-map name. " + qNameException.getMessage());
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
            }
            object = this.characterMapElements.iterator();
            while (object.hasNext()) {
                ((XSLCharacterMap)object.next()).checkCircularity(this);
            }
        }
        this.validated = true;
    }

    private void checkCircularity(XSLCharacterMap xSLCharacterMap) throws TransformerConfigurationException {
        if (this == xSLCharacterMap) {
            this.compileError("The definition of the character map is circular");
            this.characterMapElements = null;
        } else {
            if (!this.validated) {
                return;
            }
            if (this.characterMapElements != null) {
                Iterator iterator = this.characterMapElements.iterator();
                while (iterator.hasNext()) {
                    ((XSLCharacterMap)iterator.next()).checkCircularity(xSLCharacterMap);
                }
            }
        }
    }

    public void assemble(HashMap hashMap) {
        Item item;
        if (this.characterMapElements != null) {
            int n = 0;
            while (n < this.characterMapElements.size()) {
                item = (XSLCharacterMap)this.characterMapElements.get(n);
                ((XSLCharacterMap)item).assemble(hashMap);
                ++n;
            }
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((item = axisIterator.next()) != null) {
            XSLOutputCharacter xSLOutputCharacter = (XSLOutputCharacter)item;
            hashMap.put(new Integer(xSLOutputCharacter.getCodePoint()), xSLOutputCharacter.getReplacementString());
        }
        return;
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        return null;
    }
}

