/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.Err;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class XSLApplyTemplates
extends StyleElement {
    private Expression select;
    private int modeNameCode = -1;
    private boolean useCurrentMode = false;
    private boolean useTailRecursion = false;
    private Mode mode;
    private String modeAttribute;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "mode") {
                this.modeAttribute = attributeCollection.getValue(n).trim();
            } else if (string2 == "select") {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.modeAttribute != null) {
            if (this.modeAttribute.equals("#current")) {
                this.useCurrentMode = true;
            } else if (!this.modeAttribute.equals("#default")) {
                try {
                    this.modeNameCode = this.makeNameCode(this.modeAttribute.trim());
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
                catch (XPathException xPathException) {
                    this.compileError("Mode name " + Err.wrap(this.modeAttribute) + " is not a valid QName");
                }
            }
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        Object object;
        this.checkWithinTemplate();
        if (!this.useCurrentMode) {
            this.mode = this.getPrincipalStylesheet().getRuleManager().getMode(this.modeNameCode);
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((object = (NodeInfo)axisIterator.next()) != null) {
            if (object instanceof XSLSort || object instanceof XSLWithParam) continue;
            if (object.getNodeKind() == 3) {
                if (Navigator.isWhite(object.getStringValue())) continue;
                this.compileError("No character data allowed within xsl:apply-templates");
                continue;
            }
            this.compileError("Invalid element within xsl:apply-templates");
        }
        if (this.select == null) {
            this.select = new AxisExpression(3, null);
        }
        this.select = this.typeCheck("select", this.select);
        try {
            object = new RoleLocator(4, "xsl:apply-templates/select", 0);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.NODE_SEQUENCE, false, (RoleLocator)object, this.getStaticContext());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    public void markTailCalls() {
        this.useTailRecursion = true;
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        SortKeyDefinition[] sortKeyDefinitionArray = this.makeSortKeys();
        if (sortKeyDefinitionArray != null) {
            this.useTailRecursion = false;
        }
        Expression expression = this.select;
        if (sortKeyDefinitionArray != null) {
            expression = new SortExpression(this.select, sortKeyDefinitionArray);
            ExpressionTool.makeParentReferences(expression);
        }
        ApplyTemplates applyTemplates = new ApplyTemplates(expression, this.getWithParamInstructions(executable, false), this.getWithParamInstructions(executable, true), this.useCurrentMode, this.useTailRecursion, this.mode);
        ExpressionTool.makeParentReferences(applyTemplates);
        return applyTemplates;
    }
}

