/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class GroupAdjacentIterator
implements GroupIterator,
LookaheadIterator {
    private SequenceIterator population;
    private Expression keyExpression;
    private Comparator collator;
    private AtomicSortComparer comparer;
    private AtomicSortComparer.ComparisonKey currentComparisonKey;
    private XPathContext keyContext;
    private AtomicValue currentKey = null;
    private List currentMembers;
    private AtomicValue nextKey = null;
    private Item next;
    private Item current = null;
    private int position = 0;

    public GroupAdjacentIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext, Comparator comparator) throws XPathException {
        this.population = sequenceIterator;
        this.keyExpression = expression;
        this.keyContext = xPathContext;
        this.collator = comparator;
        this.comparer = new AtomicSortComparer(comparator);
        this.next = sequenceIterator.next();
        if (this.next != null) {
            this.nextKey = (AtomicValue)expression.evaluateItem(xPathContext);
        }
    }

    private void advance() throws XPathException {
        Item item;
        this.currentMembers = new ArrayList();
        this.currentMembers.add(this.current);
        while ((item = this.population.next()) != null) {
            AtomicValue atomicValue = (AtomicValue)this.keyExpression.evaluateItem(this.keyContext);
            try {
                if (this.currentComparisonKey.equals(this.comparer.getComparisonKey(atomicValue))) {
                    this.currentMembers.add(item);
                    continue;
                }
                this.next = item;
                this.nextKey = atomicValue;
                return;
            }
            catch (ClassCastException classCastException) {
                DynamicError dynamicError = new DynamicError("Grouping key values are of non-comparable types (" + this.currentKey.getItemType() + " and " + atomicValue.getItemType() + ")");
                dynamicError.setIsTypeError(true);
                dynamicError.setXPathContext(this.keyContext);
                throw dynamicError;
            }
        }
        this.next = null;
        this.nextKey = null;
    }

    public AtomicValue getCurrentGroupingKey() {
        return this.currentKey;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.currentMembers);
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() throws XPathException {
        if (this.next == null) {
            return null;
        }
        this.current = this.next;
        this.currentKey = this.nextKey;
        this.currentComparisonKey = this.comparer.getComparisonKey(this.currentKey);
        ++this.position;
        this.advance();
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        XPathContextMinor xPathContextMinor = this.keyContext.newMinorContext();
        xPathContextMinor.setOrigin(this.keyContext.getOrigin());
        return new GroupAdjacentIterator(this.population, this.keyExpression, xPathContextMinor, this.collator);
    }
}

