/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SaxonOutputKeys;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathEvaluator;
import net.sf.saxon.xpath.XPathException;

public class XQueryExpression
implements Container {
    private Expression expression;
    private SlotManager stackFrameMap;
    private Executable executable;
    private DocumentInstr documentInstruction;

    protected XQueryExpression(Expression expression, Executable executable, StaticQueryContext staticQueryContext, Configuration configuration) throws XPathException {
        this.stackFrameMap = staticQueryContext.getStackFrameMap();
        this.executable = executable;
        if (expression instanceof ComputedExpression) {
            ((ComputedExpression)expression).setParentExpression(this);
        }
        ExpressionTool.makeParentReferences(expression);
        try {
            expression = expression.simplify(staticQueryContext);
            expression = expression.analyze(staticQueryContext, Type.ITEM_TYPE);
        }
        catch (XPathException xPathException) {
            try {
                configuration.getErrorListener().error(xPathException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw xPathException;
        }
        ExpressionTool.allocateSlots(expression, 0, staticQueryContext.getStackFrameMap());
        this.expression = expression;
        this.executable.setConfiguration(configuration);
        this.executable.setDefaultCollationName(staticQueryContext.getDefaultCollationName());
        this.executable.setCollationTable(staticQueryContext.getAllCollations());
    }

    public Expression getExpression() {
        return this.expression;
    }

    protected void setDocumentInstruction(DocumentInstr documentInstr) {
        this.documentInstruction = documentInstr;
        documentInstr.setParentExpression(this);
    }

    public List evaluate(DynamicQueryContext dynamicQueryContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterator(dynamicQueryContext);
        ArrayList<Object> arrayList = new ArrayList<Object>(100);
        Item item;
        while ((item = sequenceIterator.next()) != null) {
            arrayList.add(XPathEvaluator.convert(item));
        }
        return arrayList;
    }

    public Object evaluateSingle(DynamicQueryContext dynamicQueryContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterator(dynamicQueryContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        return XPathEvaluator.convert(item);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public SequenceIterator iterator(DynamicQueryContext var1_1) throws XPathException {
        var2_2 = this.getController();
        this.initializeController(var1_1, var2_2);
        try {
            var3_3 = var1_1.getContextNode();
            var4_5 = var2_2.getBindery();
            var2_2.defineGlobalParameters(var4_5);
            var5_7 = var2_2.newXPathContext();
            if (var2_2.getConfiguration().getTraceListener() != null) {
                var2_2.preEvaluateGlobals(var5_7);
            }
            var5_7.openStackFrame(this.stackFrameMap);
            if (var3_3 != null) {
                var5_7.setCurrentIterator(SingletonIterator.makeIterator(var3_3));
                var2_2.setPrincipalSourceDocument(var3_3.getDocumentRoot());
            }
            var6_9 = this.expression.iterate(var5_7);
            return new ErrorReportingIterator(var6_9, var2_2.getErrorListener());
        }
        catch (XPathException var3_4) {
            var4_6 /* !! */  = var3_4;
            ** while (var4_6 /* !! */ .getException() instanceof TransformerException)
        }
lbl-1000:
        // 1 sources

        {
            var4_6 /* !! */  = (TransformerException)var4_6 /* !! */ .getException();
            continue;
        }
lbl21:
        // 1 sources

        try {
            var2_2.getErrorListener().error(var4_6 /* !! */ );
        }
        catch (TransformerException var5_8) {}
        throw XPathException.wrap(var4_6 /* !! */ );
    }

    private void initializeController(DynamicQueryContext dynamicQueryContext, Controller controller) {
        HashMap hashMap = dynamicQueryContext.getParameters();
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = hashMap.get(string);
                controller.setParameter(string, v);
            }
        }
        controller.setURIResolver(dynamicQueryContext.getURIResolver());
        controller.setErrorListener(dynamicQueryContext.getErrorListener());
    }

    public void run(DynamicQueryContext dynamicQueryContext, Result result, Properties properties) throws XPathException {
        OutputStream outputStream;
        Object object;
        Object object2;
        Object object3;
        Controller controller = this.getController();
        this.initializeController(dynamicQueryContext, controller);
        if (properties == null) {
            properties = new Properties();
        } else {
            object3 = properties.propertyNames();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = properties.getProperty((String)object2);
                try {
                    SaxonOutputKeys.checkOutputProperty((String)object2, (String)object);
                }
                catch (DynamicError dynamicError) {
                    try {
                        controller.getErrorListener().error(dynamicError);
                        throw dynamicError;
                    }
                    catch (TransformerException transformerException) {
                        throw DynamicError.wrap(transformerException);
                    }
                }
            }
        }
        object3 = dynamicQueryContext.getContextNode();
        object2 = controller.getBindery();
        controller.defineGlobalParameters((Bindery)object2);
        object = controller.newXPathContext();
        TraceListener traceListener = controller.getConfiguration().getTraceListener();
        if (traceListener != null) {
            controller.preEvaluateGlobals((XPathContext)object);
            traceListener.open();
        }
        ((XPathContextMajor)object).openStackFrame(this.stackFrameMap);
        if (object3 != null) {
            ((XPathContextMinor)object).setCurrentIterator(SingletonIterator.makeIterator((Item)object3));
            controller.setPrincipalSourceDocument(object3.getDocumentRoot());
        }
        boolean bl = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        ((XPathContextMinor)object).changeOutputDestination(properties, result, true, 3, null);
        try {
            this.documentInstruction.process((XPathContext)object);
        }
        catch (XPathException xPathException) {
            try {
                controller.getErrorListener().fatalError(xPathException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw xPathException;
        }
        if (traceListener != null) {
            traceListener.close();
        }
        ((XPathContextMinor)object).getReceiver().close();
        if (bl && (outputStream = ((StreamResult)result).getOutputStream()) != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new DynamicError(iOException);
            }
        }
    }

    public Controller getController() {
        Controller controller = new Controller(this.executable.getConfiguration());
        controller.setExecutable(this.executable);
        this.executable.initialiseBindery(controller.getBindery());
        return controller;
    }

    public void explain(NamePool namePool) {
        System.err.println("============ Compiled Expression ============");
        this.expression.display(10, namePool, System.err);
        System.err.println("=============================================");
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    private static class ErrorReportingIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private ErrorListener listener;

        public ErrorReportingIterator(SequenceIterator sequenceIterator, ErrorListener errorListener) {
            this.base = sequenceIterator;
            this.listener = errorListener;
        }

        public Item next() throws XPathException {
            try {
                return this.base.next();
            }
            catch (XPathException xPathException) {
                try {
                    this.listener.error(xPathException);
                }
                catch (TransformerException transformerException) {}
                throw xPathException;
            }
        }

        public Item current() {
            return this.base.current();
        }

        public int position() {
            return this.base.position();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new ErrorReportingIterator(this.base.getAnother(), this.listener);
        }
    }
}

