/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.QueryProcessor;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public class StaticQueryContext
implements StaticContext {
    private Configuration config;
    private NamePool namePool;
    private HashMap passiveNamespaces;
    private Stack activeNamespaces;
    private HashMap collations;
    private HashMap variables;
    private List variableList;
    private HashSet importedSchemata;
    private String defaultCollationName;
    private String defaultFunctionNamespace;
    private short defaultElementNamespace;
    private String baseURI;
    private SlotManager stackFrameMap;
    private String moduleNamespace;
    private short moduleNamespaceURICode;
    private int constructionMode;
    private Executable executable;
    private FunctionLibraryList functionLibraryList;
    private XQueryFunctionLibrary functions;

    public StaticQueryContext(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
        this.reset();
    }

    public void reset() {
        this.passiveNamespaces = new HashMap(10);
        this.activeNamespaces = new Stack();
        this.collations = new HashMap(5);
        this.variables = new HashMap(40);
        this.variableList = new ArrayList(40);
        this.functions = new XQueryFunctionLibrary(this.config, true);
        this.importedSchemata = new HashSet(5);
        this.defaultFunctionNamespace = "http://www.w3.org/2004/07/xpath-functions";
        this.defaultElementNamespace = 0;
        this.moduleNamespace = null;
        this.moduleNamespaceURICode = 0;
        this.constructionMode = 3;
        this.defaultCollationName = CodepointCollator.URI;
        this.declareCollation(this.defaultCollationName, CodepointCollator.getInstance());
        this.functionLibraryList = new FunctionLibraryList();
        this.functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(this.config, false));
        this.functionLibraryList.addFunctionLibrary(this.config.getVendorFunctionLibrary());
        this.functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.config));
        if (this.config.isAllowExternalFunctions()) {
            this.functionLibraryList.addFunctionLibrary(new JavaExtensionLibrary(this.config));
        }
        this.functionLibraryList.addFunctionLibrary(this.functions);
        this.clearNamespaces();
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        return new QueryProcessor(this).buildDocument(source);
    }

    public XQueryExpression compileQuery(String string) throws XPathException {
        return new QueryProcessor(this).compileQuery(string);
    }

    public XQueryExpression compileQuery(Reader reader) throws XPathException, IOException {
        return new QueryProcessor(this).compileQuery(reader);
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public LocationMap getLocationMap() {
        return this.executable.getLocationMap();
    }

    protected void declarePassiveNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declarePassiveNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declarePassiveNamespace()");
        }
        this.passiveNamespaces.put(string, string2);
        this.namePool.allocateNamespaceCode(string, string2);
    }

    protected void declareActiveNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareActiveNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareActiveNamespace()");
        }
        int n = this.namePool.allocateNamespaceCode(string, string2);
        ActiveNamespace activeNamespace = new ActiveNamespace();
        activeNamespace.prefix = string;
        activeNamespace.uri = string2;
        activeNamespace.code = n;
        this.activeNamespaces.push(activeNamespace);
        if (string.equals("")) {
            this.defaultElementNamespace = (short)(n & 0xFFFF);
        }
    }

    public void undeclareNamespace() {
        ActiveNamespace activeNamespace = (ActiveNamespace)this.activeNamespaces.pop();
        if (activeNamespace.prefix.equals("")) {
            int n = this.activeNamespaces.size() - 1;
            while (n >= 0) {
                if (((ActiveNamespace)this.activeNamespaces.get((int)n)).prefix.equals("")) {
                    this.defaultElementNamespace = (short)(((ActiveNamespace)this.activeNamespaces.get((int)n)).code & 0xFFFF);
                    return;
                }
                --n;
            }
            this.defaultElementNamespace = 0;
        }
    }

    public void clearNamespaces() {
        if (this.passiveNamespaces != null) {
            this.passiveNamespaces.clear();
            this.declarePassiveNamespace("xml", "http://www.w3.org/XML/1998/namespace");
            this.declarePassiveNamespace("saxon", "http://saxon.sf.net/");
            this.declarePassiveNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            this.declarePassiveNamespace("fn", "http://www.w3.org/2004/07/xpath-functions");
            this.declarePassiveNamespace("xdt", "http://www.w3.org/2004/07/xpath-datatypes");
            this.declarePassiveNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.declarePassiveNamespace("local", "http://www.w3.org/2004/07/xquery-local-functions");
            this.declarePassiveNamespace("", "");
        }
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.checkURIForPrefix(string);
        if (string2 == null) {
            throw new StaticError("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public String checkURIForPrefix(String string) {
        int n = this.activeNamespaces.size() - 1;
        while (n >= 0) {
            if (((ActiveNamespace)this.activeNamespaces.get((int)n)).prefix.equals(string)) {
                return ((ActiveNamespace)this.activeNamespaces.get((int)n)).uri;
            }
            --n;
        }
        return (String)this.passiveNamespaces.get(string);
    }

    public int[] getActiveNamespaceCodes() {
        Object object;
        Object object2 = new int[this.activeNamespaces.size()];
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>(10);
        int n2 = this.activeNamespaces.size() - 1;
        while (n2 >= 0) {
            object = (ActiveNamespace)this.activeNamespaces.get(n2);
            if (!hashSet.contains(((ActiveNamespace)object).prefix)) {
                hashSet.add(((ActiveNamespace)object).prefix);
                object2[n++] = ((ActiveNamespace)object).code;
            }
            --n2;
        }
        if (n < ((int[])object2).length) {
            object = new int[n];
            System.arraycopy(object2, 0, object, 0, n);
            object2 = object;
        }
        return object2;
    }

    public NamespaceResolver getNamespaceResolver() {
        int[] nArray = this.getActiveNamespaceCodes();
        int[] nArray2 = new int[this.passiveNamespaces.size() + nArray.length];
        int n = 0;
        Iterator iterator = this.passiveNamespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.passiveNamespaces.get(string);
            nArray2[n++] = this.namePool.getNamespaceCode(string, string2);
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n++] = nArray[n2];
            ++n2;
        }
        return new NamespaceContext(nArray2, this.namePool);
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.defaultFunctionNamespace = string;
    }

    protected void setDefaultElementNamespace(String string) {
        int n = this.namePool.allocateNamespaceCode("", string);
        this.defaultElementNamespace = (short)(n & 0xFFFF);
        this.declarePassiveNamespace("", string);
    }

    public short getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setModuleNamespace(String string) {
        this.moduleNamespace = string;
        this.moduleNamespaceURICode = this.namePool.getCodeForURI(string);
    }

    public String getModuleNamespace() {
        return this.moduleNamespace;
    }

    public short getModuleNamespaceCode() {
        return this.moduleNamespaceURICode;
    }

    public void declareCollation(String string, Comparator comparator) {
        this.collations.put(string, comparator);
    }

    public void declareDefaultCollation(String string) throws XPathException {
        Comparator comparator = this.getCollation(string);
        if (comparator == null) {
            throw new StaticError("Collation " + string + " is not recognized");
        }
        this.defaultCollationName = string;
    }

    public Comparator getCollation(String string) {
        Comparator comparator = (Comparator)this.collations.get(string);
        if (comparator != null) {
            return comparator;
        }
        try {
            return CollationFactory.makeCollationFromURI(string);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return CodepointCollator.URI;
    }

    public HashMap getAllCollations() {
        return new HashMap(this.collations);
    }

    public SlotManager getGlobalStackFrameMap() {
        return this.executable.getGlobalVariableMap();
    }

    public void declareVariable(VariableDeclaration variableDeclaration) throws StaticError {
        int n = variableDeclaration.getNameCode();
        Integer n2 = new Integer(n);
        if (this.variables.get(n2) != null) {
            throw new StaticError("Duplicate definition of global variable " + variableDeclaration.getVariableName());
        }
        this.variables.put(n2, variableDeclaration);
        this.variableList.add(variableDeclaration);
    }

    public void fixupGlobalVariables(SlotManager slotManager) throws StaticError {
        Iterator iterator = this.variableList.iterator();
        while (iterator.hasNext()) {
            GlobalVariableDefinition globalVariableDefinition = (GlobalVariableDefinition)iterator.next();
            try {
                int n = slotManager.allocateSlotNumber(globalVariableDefinition.getNameCode() & 0xFFFFF);
                globalVariableDefinition.compile(this, n);
            }
            catch (XPathException xPathException) {
                if (xPathException instanceof StaticError) {
                    throw (StaticError)xPathException;
                }
                throw new StaticError(xPathException);
            }
        }
    }

    public void explainGlobalVariables() {
        Iterator iterator = this.variableList.iterator();
        while (iterator.hasNext()) {
            GlobalVariableDefinition globalVariableDefinition = (GlobalVariableDefinition)iterator.next();
            globalVariableDefinition.explain(this.getNamePool());
        }
    }

    public Iterator getVariableDeclarations() {
        return this.variableList.iterator();
    }

    public SlotManager getStackFrameMap() {
        if (this.stackFrameMap == null) {
            this.stackFrameMap = this.getConfiguration().makeSlotManager();
        }
        return this.stackFrameMap;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String string) {
        System.err.println(string);
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public VariableDeclaration bindVariable(int n) throws StaticError {
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.variables.get(new Integer(n));
        if (variableDeclaration == null) {
            throw new StaticError("Undeclared variable in query");
        }
        return variableDeclaration;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibraryList;
    }

    public void declareFunction(XQueryFunction xQueryFunction) throws StaticError {
        int n = xQueryFunction.getFunctionFingerprint();
        if (this.moduleNamespace != null && this.namePool.getURICode(n) != this.moduleNamespaceURICode) {
            throw new StaticError("Function " + this.namePool.getDisplayName(n) + " is not defined in the module namespace");
        }
        this.functions.declareFunction(xQueryFunction);
    }

    protected void bindUnboundFunctionCalls() throws StaticError {
        this.functions.bindUnboundFunctionCalls();
    }

    public Iterator getFunctionDefinitions() {
        return this.functions.getFunctionDefinitions();
    }

    protected void fixupGlobalFunctions() throws StaticError {
        this.functions.fixupGlobalFunctions(this);
    }

    public void explainGlobalFunctions() throws XPathException {
        this.functions.explainGlobalFunctions();
    }

    public UserFunction getUserDefinedFunction(String string, String string2, int n) {
        return this.functions.getUserDefinedFunction(string, string2, n);
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public void addImportedSchema(String string) {
        if (this.importedSchemata == null) {
            this.importedSchemata = new HashSet(5);
        }
        this.importedSchemata.add(string);
    }

    public boolean isImportedSchema(String string) {
        if (this.importedSchemata == null) {
            return false;
        }
        return this.importedSchemata.contains(string);
    }

    public void setConstructionMode(int n) {
        this.constructionMode = n;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    protected StaticQueryContext loadModule(String string, String string2) throws StaticError {
        return StaticQueryContext.loadQueryModule(this.config, this.executable, this.baseURI, string, string2);
    }

    public static StaticQueryContext loadQueryModule(Configuration configuration, Executable executable, String string, String string2, String string3) throws StaticError {
        URL uRL;
        StaticQueryContext staticQueryContext = executable.getQueryLibraryModule(string2);
        if (staticQueryContext != null) {
            return staticQueryContext;
        }
        if (string3 == null) {
            throw new StaticError("import module must either specify a known namespace or a location");
        }
        if (string == null) {
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new StaticError("Cannot resolve URI (no base URI available)", malformedURLException);
            }
        }
        try {
            uRL = new URL(new URL(string), string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new StaticError("Cannot resolve relative URI", malformedURLException);
        }
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer(2048);
            char[] cArray = new char[2048];
            while ((n = bufferedReader.read(cArray, 0, 2048)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            bufferedReader.close();
            inputStream.close();
            StaticQueryContext staticQueryContext2 = new StaticQueryContext(configuration);
            staticQueryContext2.setBaseURI(uRL.toString());
            staticQueryContext2.setExecutable(executable);
            QueryParser queryParser = new QueryParser();
            queryParser.parseLibraryModule(stringBuffer.toString(), staticQueryContext2);
            if (staticQueryContext2.getModuleNamespace() == null) {
                throw new StaticError("Imported module must be a library module");
            }
            if (!staticQueryContext2.getModuleNamespace().equals(string2)) {
                throw new StaticError("Imported module's namespace does not match requested namespace");
            }
            executable.addQueryLibraryModule(staticQueryContext2);
            return staticQueryContext2;
        }
        catch (IOException iOException) {
            throw new StaticError(iOException);
        }
    }

    private static class ActiveNamespace {
        public String prefix;
        public String uri;
        public int code;

        private ActiveNamespace() {
        }
    }
}

