/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public final class KeyPattern
extends Pattern {
    private int keyfingerprint;
    private Expression keyexp;

    public KeyPattern(int n, Expression expression) {
        this.keyfingerprint = n & 0xFFFFF;
        this.keyexp = expression;
    }

    public Pattern typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.keyexp = this.keyexp.analyze(staticContext, itemType);
        return this;
    }

    public boolean matches(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
        if (documentInfo == null) {
            return false;
        }
        KeyManager keyManager = xPathContext.getController().getKeyManager();
        SequenceIterator sequenceIterator = this.keyexp.iterate(xPathContext);
        block0: while (true) {
            NodeInfo nodeInfo2;
            Item item;
            if ((item = sequenceIterator.next()) == null) {
                return false;
            }
            SequenceIterator sequenceIterator2 = keyManager.selectByKey(this.keyfingerprint, documentInfo, (AtomicValue)item, xPathContext);
            do {
                if ((nodeInfo2 = (NodeInfo)sequenceIterator2.next()) == null) continue block0;
            } while (!nodeInfo2.isSameNodeInfo(nodeInfo));
            break;
        }
        return true;
    }

    public NodeTest getNodeTest() {
        return AnyNodeTest.getInstance();
    }
}

