/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.ReverseArrayIterator;
import net.sf.saxon.om.SequenceIterator;

public final class ArrayIterator
implements AxisIterator,
ReversibleIterator,
LastPositionFinder,
LookaheadIterator {
    private Item[] items;
    private int index = 0;
    private int start;
    private int end;
    private Item current = null;

    public ArrayIterator(Item[] itemArray) {
        this.items = itemArray;
        this.start = 0;
        this.end = itemArray.length;
        this.index = 0;
    }

    public ArrayIterator(Item[] itemArray, int n, int n2) {
        this.items = itemArray;
        this.end = n2;
        this.start = n;
        this.index = n;
    }

    public SequenceIterator makeSliceIterator(int n, int n2) {
        int n3;
        int n4;
        Item[] itemArray = this.getArray();
        int n5 = this.getStartPosition();
        int n6 = n5 + this.getEndPosition();
        if (n < 1) {
            n = 1;
        }
        if ((n4 = n5 + (n - 1)) < n5) {
            n4 = n5;
        }
        if ((n3 = n4 + (n2 - n + 1)) > n6) {
            n3 = n6;
        }
        return new ArrayIterator(itemArray, n4, n3);
    }

    public boolean hasNext() {
        return this.index < this.end;
    }

    public Item next() {
        if (this.index >= this.end) {
            return null;
        }
        this.current = this.items[this.index++];
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.index - this.start;
    }

    public int getLastPosition() {
        return this.end - this.start;
    }

    public SequenceIterator getAnother() {
        return new ArrayIterator(this.items, this.start, this.end);
    }

    public SequenceIterator getReverseIterator() {
        return new ReverseArrayIterator(this.items, this.start, this.end);
    }

    public Item[] getArray() {
        return this.items;
    }

    public int getStartPosition() {
        return this.start;
    }

    public int getEndPosition() {
        return this.end;
    }
}

