/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Controller;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class ResultDocument
extends InstructionWithChildren {
    private Expression href;
    private Properties outputProperties;
    private String baseURI;
    private int validationAction;
    private SchemaType schemaType;
    private HashMap serializationAttributes;
    private NamespaceResolver nsResolver;

    public ResultDocument(Properties properties, Expression expression, String string, int n, SchemaType schemaType, HashMap hashMap, NamespaceResolver namespaceResolver) {
        this.outputProperties = properties;
        this.href = expression;
        this.baseURI = string;
        this.validationAction = n;
        this.schemaType = schemaType;
        this.serializationAttributes = hashMap;
        this.nsResolver = namespaceResolver;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            this.adoptChildExpression((Expression)iterator.next());
        }
    }

    public int getInstructionNameCode() {
        return 174;
    }

    public ItemType getItemType() {
        return NoNodeTest.getInstance();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.href = this.href.promote(promotionOffer);
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(6);
        if (this.children != null) {
            arrayList.addAll(Arrays.asList(this.children));
        }
        if (this.href != null) {
            arrayList.add(this.href);
        }
        Iterator iterator = this.serializationAttributes.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add((Expression)iterator.next());
        }
        return arrayList.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Object object;
        Object object2;
        Object object3;
        Result result;
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        OutputURIResolver outputURIResolver = null;
        if (this.href == null) {
            result = controller.getPrincipalResult();
        } else {
            try {
                outputURIResolver = controller.getOutputURIResolver();
                String string = this.href.evaluateAsString(xPathContext);
                result = outputURIResolver.resolve(string, controller.getPrincipalResultURI());
                if (result == null) {
                    outputURIResolver = StandardOutputResolver.getInstance();
                    result = outputURIResolver.resolve(string, controller.getPrincipalResultURI());
                }
            }
            catch (TransformerException transformerException) {
                throw XPathException.wrap(transformerException);
            }
        }
        boolean bl = controller.getConfiguration().isTiming();
        if (bl) {
            object3 = result.getSystemId();
            if (object3 == null) {
                object3 = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            System.err.println("Writing to " + (String)object3);
        }
        object3 = this.outputProperties;
        if (this.serializationAttributes.size() > 0) {
            object3 = new Properties(this.outputProperties);
            object2 = xPathContext.getController().getNamePool();
            object = this.serializationAttributes.keySet().iterator();
            while (object.hasNext()) {
                Integer n = (Integer)object.next();
                Expression expression = (Expression)this.serializationAttributes.get(n);
                String string = expression.evaluateAsString(xPathContext);
                try {
                    ResultDocument.setSerializationProperty((Properties)object3, n, string, (NamePool)object2, this.nsResolver);
                }
                catch (DynamicError dynamicError) {
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setLocator(this.getSourceLocator());
                    throw dynamicError;
                }
            }
        }
        if ((object2 = this.outputProperties.getProperty("{http://saxon.sf.net/}next-in-chain")) != null) {
            try {
                result = controller.prepareNextStylesheet((String)object2, this.baseURI, result);
            }
            catch (TransformerException transformerException) {
                throw XPathException.wrap(transformerException);
            }
        }
        xPathContextMinor.changeOutputDestination((Properties)object3, result, true, this.validationAction, this.schemaType);
        this.processChildren(xPathContextMinor);
        object = xPathContextMinor.getReceiver();
        object.close();
        if (outputURIResolver != null) {
            try {
                outputURIResolver.close(result);
            }
            catch (TransformerException transformerException) {
                throw XPathException.wrap(transformerException);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setSerializationProperty(Properties properties, int n, String string, NamePool namePool, NamespaceResolver namespaceResolver) throws XPathException {
        String string2 = namePool.getLocalName(n);
        String string3 = namePool.getURI(n);
        if (string3.equals("")) {
            if (string2.equals("method")) {
                if (string.equals("xml") || string.equals("html") || string.equals("text") || string.equals("xhtml")) {
                    properties.put("method", string);
                    return;
                } else {
                    try {
                        String[] stringArray = Name.getQNameParts(string);
                        String string4 = stringArray[0];
                        if (string4.equals("")) {
                            throw new DynamicError("method must be xml, html, xhtml, or text, or a prefixed name");
                        }
                        String string5 = namespaceResolver.getURIForPrefix(string4, false);
                        if (string5 == null) {
                            throw new DynamicError("Namespace prefix '" + string4 + "' has not been declared");
                        }
                        properties.put("method", '{' + string5 + '}' + stringArray[1]);
                        return;
                    }
                    catch (QNameException qNameException) {
                        throw new DynamicError("Invalid method name. " + qNameException.getMessage());
                    }
                }
            }
            if (string2.equals("output-version")) {
                properties.put("version", string);
                return;
            }
            if (string2.equals("indent")) {
                if (!string.equals("yes") && !string.equals("no")) throw new DynamicError("indent must be yes or no");
                properties.put("indent", string);
                return;
            }
            if (string2.equals("encoding")) {
                properties.put("encoding", string);
                return;
            }
            if (string2.equals("media-type")) {
                properties.put("media-type", string);
                return;
            }
            if (string2.equals("doctype-system")) {
                properties.put("doctype-system", string);
                return;
            }
            if (string2.equals("doctype-public")) {
                properties.put("doctype-public", string);
                return;
            }
            if (string2.equals("omit-xml-declaration")) {
                if (!string.equals("yes") && !string.equals("no")) throw new DynamicError("omit-xml-declaration attribute must be yes or no");
                properties.put("omit-xml-declaration", string);
                return;
            }
            if (string2.equals("standalone")) {
                if (!string.equals("yes") && !string.equals("no") && !string.equals("omit")) return;
                properties.put("standalone", string);
                throw new DynamicError("standalone attribute must be yes or no or omit");
            }
            if (string2.equals("cdata-section-elements")) {
                String string6 = properties.getProperty("cdata-section-elements");
                if (string6 == null) {
                    string6 = "";
                }
                String string7 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    try {
                        String[] stringArray = Name.getQNameParts(string8);
                        String string9 = namespaceResolver.getURIForPrefix(stringArray[0], true);
                        if (string9 == null) {
                            throw new DynamicError("Namespace prefix '" + stringArray[0] + "' has not been declared");
                        }
                        string7 = string7 + " {" + string9 + '}' + stringArray[1];
                    }
                    catch (QNameException qNameException) {
                        throw new DynamicError("Invalid CDATA element name. " + qNameException.getMessage());
                    }
                    properties.put("cdata-section-elements", string6 + string7);
                }
                return;
            }
            if (string2.equals("undeclare-namespaces")) {
                if (!string.equals("yes") && !string.equals("no")) throw new DynamicError("undeclare-namespaces value must be yes or no");
                properties.put("undeclare-namespaces", string);
                return;
            } else if (string2.equals("include-content-type")) {
                if (!string.equals("yes") && !string.equals("no")) throw new DynamicError("include-content-type attribute must be yes or no");
                properties.put("include-content-type", string);
                return;
            } else {
                if (!string2.equals("escape-uri-attributes")) return;
                if (!string.equals("yes") && !string.equals("no")) throw new DynamicError("escape-uri-attributes value must be yes or no");
                properties.put("escape-uri-attibutes", string);
            }
            return;
        }
        if (string3.equals("http://saxon.sf.net/")) {
            if (string2.equals("character-representation")) {
                properties.put("{http://saxon.sf.net/}character-representation", string);
                return;
            } else if (string2.equals("indent-spaces")) {
                try {
                    Integer.parseInt(string);
                    properties.put("indent", "yes");
                    properties.put("{http://saxon.sf.net/}indent-spaces", string);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DynamicError("saxon:indent-spaces must be an integer");
                }
            } else {
                if (string2.equals("next-in-chain")) {
                    throw new DynamicError("saxon:next-in-chain value cannot be specified dynamically");
                }
                if (string2.equals("byte-order-mark")) {
                    if (!string.equals("yes") && !string.equals("no")) throw new DynamicError("saxon:byte-order-mark value must be yes or no");
                    properties.put("{http://saxon.sf.net/}byte-order-mark", string);
                    return;
                } else {
                    if (!string2.equals("require-well-formed")) return;
                    if (!string.equals("yes") && !string.equals("no")) throw new DynamicError("saxon:require-well-formed value must be yes or no");
                    properties.put("{http://saxon.sf.net/}require-well-formed", string);
                }
            }
            return;
        } else {
            properties.put('{' + string3 + '}' + string2, string);
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "result-document");
        InstructionWithChildren.displayChildren(this.children, n + 1, namePool, printStream);
    }
}

