/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Err;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.SkipInstructionException;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class ProcessingInstruction
extends SimpleNodeConstructor {
    private Expression name;

    public ProcessingInstruction(Expression expression) {
        this.name = expression;
    }

    public int getInstructionNameCode() {
        return 173;
    }

    public ItemType getItemType() {
        return NodeKindTest.PROCESSING_INSTRUCTION;
    }

    public int getCardinality() {
        return 512;
    }

    public void typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.name = this.name.analyze(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(4, "processing-instruction:name", 0);
        this.name = TypeChecker.staticTypeCheck(this.name, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
    }

    public int getDependencies() {
        return this.name.getDependencies() | super.getDependencies();
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(6);
        if (this.children != null) {
            arrayList.addAll(Arrays.asList(this.children));
        }
        if (this.select != null) {
            arrayList.add(this.select);
        }
        if (this.separator != null && !(this.separator instanceof StringValue)) {
            arrayList.add(this.separator);
        }
        arrayList.add(this.name);
        return arrayList.iterator();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.name = this.name.promote(promotionOffer);
        super.promoteInst(promotionOffer);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        String string = this.evaluateName(xPathContext);
        if (string != null) {
            String string2 = this.expandChildren(xPathContext).toString();
            string2 = this.checkContent(string2, xPathContext);
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            sequenceReceiver.processingInstruction(string, string2, this.locationId, 0);
        }
        return null;
    }

    protected String checkContent(String string, XPathContext xPathContext) throws DynamicError {
        int n = string.indexOf("?>");
        if (n >= 0) {
            DynamicError dynamicError = new DynamicError("Invalid characters (?>) in processing instruction", this);
            if (xPathContext.getController().getConfiguration().getHostLanguage() == 10) {
                dynamicError.setErrorCode("XT0900");
            } else {
                dynamicError.setErrorCode("XQ0026");
            }
            dynamicError.setXPathContext(xPathContext);
            xPathContext.getController().recoverableError(dynamicError);
            string = string.substring(0, n + 1) + ' ' + string.substring(n + 1);
        }
        return string;
    }

    protected int evaluateNameCode(XPathContext xPathContext) throws XPathException {
        String string = this.evaluateName(xPathContext);
        if (string == null) {
            throw new SkipInstructionException("");
        }
        return xPathContext.getController().getNamePool().allocate("", "", string);
    }

    private String evaluateName(XPathContext xPathContext) throws XPathException {
        DynamicError dynamicError;
        String string = this.name.evaluateAsString(xPathContext);
        if (!XMLChar.isValidNCName(string)) {
            dynamicError = new DynamicError("Processing instruction name " + Err.wrap(string) + " is not a valid NCName");
            dynamicError.setXPathContext(xPathContext);
            if (xPathContext.getController().getConfiguration().getHostLanguage() == 11) {
                dynamicError.setErrorCode("XQ0041");
            } else {
                dynamicError.setErrorCode("XT0890");
            }
            xPathContext.getController().recoverableError(dynamicError);
        }
        if (string.equalsIgnoreCase("xml")) {
            dynamicError = new DynamicError("Processing instructions cannot be named 'xml' in any combination of upper/lower case");
            dynamicError.setXPathContext(xPathContext);
            if (xPathContext.getController().getConfiguration().getHostLanguage() == 11) {
                dynamicError.setErrorCode("XQ0064");
            } else {
                dynamicError.setErrorCode("XT0890");
            }
            xPathContext.getController().recoverableError(dynamicError);
        }
        return string;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "processing-instruction");
        this.name.display(n + 1, namePool, printStream);
        super.display(n + 1, namePool, printStream);
    }
}

