/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.xpath.XPathException;

public class Block
extends InstructionWithChildren
implements MappingFunction {
    public final ItemType getItemType() {
        if (this.children == null || this.children.length == 0) {
            return NoNodeTest.getInstance();
        }
        ItemType itemType = this.children[0].getItemType();
        int n = 1;
        while (n < this.children.length) {
            if ((itemType = Type.getCommonSuperType(itemType, this.children[n].getItemType())) instanceof AnyItemType) {
                return itemType;
            }
            ++n;
        }
        return itemType;
    }

    public final int getCardinality() {
        if (this.children == null || this.children.length == 0) {
            return 256;
        }
        int n = this.children[0].getCardinality();
        int n2 = 1;
        while (n2 < this.children.length) {
            n = Cardinality.add(n, this.children[n2].getCardinality());
            ++n2;
        }
        return n;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Expression expression = super.simplify(staticContext);
        if (expression != this) {
            return expression;
        }
        if (this.children == null || this.getChildren().length == 0) {
            return EmptySequence.getInstance();
        }
        if (this.getChildren().length == 1) {
            return this.getChildren()[0];
        }
        return this;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n] = this.children[n].promote(promotionOffer);
                ++n;
            }
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        if (this.children != null) {
            InstructionWithChildren.displayChildren(this.children, n + 1, namePool, printStream);
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        return this.processChildrenLeavingTail(xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.children == null || this.children.length == 0) {
            return EmptyIterator.getInstance();
        }
        if (this.children.length == 1) {
            return this.children[0].iterate(xPathContext);
        }
        RangeExpression.RangeIterator rangeIterator = new RangeExpression.RangeIterator(0L, this.children.length - 1);
        return new MappingIterator(rangeIterator, this, null, xPathContext);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        int n = (int)((IntegerValue)item).longValue();
        return this.children[n].iterate((XPathContext)object);
    }
}

