/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.ParameterSet;
import net.sf.saxon.instruct.GlobalParam;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class Bindery {
    private Value[] globals;
    private boolean[] busy;
    private ParameterSet globalParameters;
    private SlotManager globalVariableMap;

    public void allocateGlobals(SlotManager slotManager) {
        this.globalVariableMap = slotManager;
        int n = slotManager.getNumberOfVariables() + 1;
        this.globals = new Value[n];
        this.busy = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.globals[n2] = null;
            this.busy[n2] = false;
            ++n2;
        }
    }

    public void defineGlobalParameters(ParameterSet parameterSet) {
        this.globalParameters = parameterSet;
    }

    public boolean useGlobalParameter(int n, GlobalParam globalParam) throws XPathException {
        if (this.globalParameters == null) {
            return false;
        }
        Value value = this.globalParameters.get(n);
        if (value == null) {
            return false;
        }
        ItemType itemType = globalParam.getRequiredType().getPrimaryType();
        if (value instanceof AtomicValue && itemType instanceof AtomicType) {
            value = ((AtomicValue)value).convert((AtomicType)itemType, null);
        } else {
            if (!Type.isSubType(value.getItemType(), itemType)) {
                DynamicError dynamicError = new DynamicError("Global parameter requires type " + itemType + "; supplied value has type " + value.getItemType());
                dynamicError.setIsTypeError(true);
                throw dynamicError;
            }
            int n2 = globalParam.getRequiredType().getCardinality();
            if (!Cardinality.subsumes(n2, value.getCardinality())) {
                DynamicError dynamicError = new DynamicError("Supplied value of external parameter does not match the required cardinality");
                dynamicError.setIsTypeError(true);
                throw dynamicError;
            }
        }
        this.globals[globalParam.getSlotNumber()] = value;
        return true;
    }

    public void defineGlobalVariable(GlobalVariable globalVariable, Value value) {
        this.globals[globalVariable.getSlotNumber()] = value;
    }

    public void setExecuting(GlobalVariable globalVariable, boolean bl) throws XPathException {
        int n = globalVariable.getSlotNumber();
        if (bl) {
            if (this.busy[n]) {
                throw new XPathException.Circularity("Circular definition");
            }
            this.busy[n] = true;
        } else {
            this.busy[n] = false;
        }
    }

    public Value getGlobalVariableValue(GlobalVariable globalVariable) {
        return this.globals[globalVariable.getSlotNumber()];
    }

    public Value getGlobalVariable(int n) {
        return this.globals[n];
    }

    public void assignGlobalVariable(GlobalVariable globalVariable, Value value) {
        this.defineGlobalVariable(globalVariable, value);
    }

    public SlotManager getGlobalVariableMap() {
        return this.globalVariableMap;
    }

    public Value[] getGlobalVariables() {
        return this.globals;
    }
}

