/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.xpath.XPathException;

public class Insert
extends SystemFunction {
    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        int n = (int)numericValue.longValue();
        SequenceIterator sequenceIterator2 = this.argument[2].iterate(xPathContext);
        return new InsertIterator(sequenceIterator, sequenceIterator2, n);
    }

    private class InsertIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private SequenceIterator insert;
        private int insertPosition;
        private int position = 0;
        private Item current = null;
        private boolean inserting = false;

        public InsertIterator(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, int n) throws XPathException {
            this.base = sequenceIterator;
            this.insert = sequenceIterator2;
            this.insertPosition = n < 1 ? 1 : n;
            this.inserting = n == 1;
        }

        public Item next() throws XPathException {
            Item item = null;
            if (this.inserting) {
                item = this.insert.next();
                if (item == null) {
                    this.inserting = false;
                    item = this.base.next();
                }
            } else if (this.position == this.insertPosition - 1) {
                item = this.insert.next();
                if (item == null) {
                    item = this.base.next();
                } else {
                    this.inserting = true;
                }
            } else {
                item = this.base.next();
                if (item == null && this.position < this.insertPosition - 1) {
                    this.inserting = true;
                    item = this.insert.next();
                }
            }
            if (item == null) {
                return null;
            }
            this.current = item;
            ++this.position;
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new InsertIterator(this.base.getAnother(), this.insert.getAnother(), this.insertPosition);
        }
    }
}

