/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ConvertToString;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UntypedAtomicConverter;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public final class TypeChecker {
    private TypeChecker() {
    }

    public static Expression staticTypeCheck(Expression expressionArray, SequenceType sequenceType, boolean bl, RoleLocator roleLocator, StaticContext staticContext) throws StaticError {
        Object object;
        int n;
        boolean bl2;
        boolean bl3;
        Object object2 = expressionArray;
        ItemType itemType = sequenceType.getPrimaryType();
        int n2 = sequenceType.getCardinality();
        boolean bl4 = Cardinality.allowsMany(n2);
        ItemType itemType2 = null;
        int n3 = -1;
        boolean bl5 = bl3 = n2 == 1792;
        if (!bl3) {
            n3 = object2.getCardinality();
            bl3 = Cardinality.subsumes(n2, n3);
        }
        if (!(bl2 = sequenceType.getPrimaryType() instanceof AnyItemType)) {
            itemType2 = object2.getItemType();
            n = Type.relationship(itemType, itemType2);
            boolean bl6 = bl2 = n == 0 || n == 1;
            if (!bl2) {
                if (Type.isPromotable(itemType2, itemType)) {
                    bl2 = true;
                    object = bl4 ? new AtomicSequenceConverter((Expression)object2, (AtomicType)itemType) : new CastExpression((Expression)object2, (AtomicType)itemType, true);
                    if (object2 instanceof Value) {
                        try {
                            object2 = ExpressionTool.eagerEvaluate((Expression)object, null);
                        }
                        catch (XPathException xPathException) {
                            throw new StaticError(xPathException);
                        }
                    } else {
                        ((ComputedExpression)object).adoptChildExpression((Expression)object2);
                        object2 = object;
                    }
                    itemType2 = itemType;
                }
                if (itemType2.getPrimitiveType() == 642) {
                    bl2 = true;
                    object = bl4 ? new AtomicSequenceConverter((Expression)object2, (AtomicType)itemType) : new CastExpression((Expression)object2, (AtomicType)itemType, true);
                    if (object2 instanceof Value) {
                        try {
                            object2 = ExpressionTool.eagerEvaluate((Expression)object, null);
                        }
                        catch (XPathException xPathException) {
                            throw new StaticError(xPathException);
                        }
                    } else {
                        ((ComputedExpression)object).adoptChildExpression((Expression)object2);
                        object2 = object;
                    }
                    itemType2 = itemType;
                }
            }
        }
        if (bl2 && bl3) {
            return object2;
        }
        if (n3 == -1) {
            n3 = object2.getCardinality();
            if (!bl3) {
                bl3 = Cardinality.subsumes(n2, n3);
            }
        }
        if (bl3 && n3 == 256) {
            return object2;
        }
        if (itemType2 == null) {
            itemType2 = object2.getItemType();
        }
        if (n3 == 256 && (n2 & 0x100) == 0) {
            StaticError staticError = new StaticError("An empty sequence is not allowed as the " + roleLocator.getMessage(), ExpressionTool.getLocator((Expression)expressionArray));
            staticError.setErrorCode(roleLocator.getErrorCode());
            staticError.setIsTypeError(true);
            throw staticError;
        }
        if (bl && !bl4) {
            if (Type.isSubType(itemType, Type.STRING_TYPE)) {
                if (!Type.isSubType(itemType2, Type.ANY_ATOMIC_TYPE)) {
                    Atomizer atomizer = new Atomizer((Expression)object2);
                    atomizer.adoptChildExpression((Expression)object2);
                    object2 = atomizer;
                }
                ConvertToString convertToString = new ConvertToString((Expression)object2);
                if (object2 instanceof Value) {
                    try {
                        object2 = ExpressionTool.eagerEvaluate(convertToString, null);
                    }
                    catch (XPathException xPathException) {
                        throw new StaticError(xPathException);
                    }
                } else {
                    convertToString.adoptChildExpression((Expression)object2);
                    object2 = convertToString;
                }
                itemType2 = Type.STRING_TYPE;
                n3 = 512;
                bl3 = Cardinality.subsumes(n2, n3);
            } else if (itemType == Type.NUMBER_TYPE || Type.isSubType(itemType, Type.DOUBLE_TYPE)) {
                NumberFn numberFn = (NumberFn)SystemFunction.makeSystemFunction("number", staticContext.getNamePool());
                object = new Expression[]{object2};
                numberFn.setArguments((Expression[])object);
                if (object2 instanceof Value) {
                    try {
                        object2 = ExpressionTool.eagerEvaluate(numberFn, null);
                    }
                    catch (XPathException xPathException) {
                        throw new StaticError(xPathException);
                    }
                } else {
                    numberFn.adoptChildExpression((Expression)object2);
                    object2 = numberFn;
                }
                itemType2 = Type.DOUBLE_TYPE;
                n3 = 512;
                bl3 = Cardinality.subsumes(n2, n3);
            } else if (itemType instanceof AnyNodeTest || itemType instanceof AnyItemType || itemType == Type.ANY_ATOMIC_TYPE) {
                if (Cardinality.allowsMany(n3)) {
                    FirstItemExpression firstItemExpression = new FirstItemExpression((Expression)object2);
                    firstItemExpression.adoptChildExpression((Expression)object2);
                    object2 = firstItemExpression;
                }
                n3 = 768;
                bl3 = Cardinality.subsumes(n2, n3);
            }
        }
        if (itemType instanceof AtomicType && !(itemType2 instanceof AtomicType) && n3 != 256) {
            Atomizer atomizer = new Atomizer((Expression)object2);
            object2 = atomizer;
            itemType2 = object2.getItemType();
            n3 = object2.getCardinality();
            bl3 = Cardinality.subsumes(n2, n3);
        }
        if (itemType != Type.ANY_ATOMIC_TYPE && itemType instanceof AtomicType && itemType2 instanceof AtomicType && (itemType2 == Type.ANY_ATOMIC_TYPE || itemType2 == Type.UNTYPED_ATOMIC_TYPE) && n3 != 256) {
            UntypedAtomicConverter untypedAtomicConverter = new UntypedAtomicConverter((Expression)object2, (AtomicType)itemType);
            untypedAtomicConverter.adoptChildExpression((Expression)object2);
            object2 = untypedAtomicConverter;
            itemType2 = object2.getItemType();
            n3 = object2.getCardinality();
            bl3 = Cardinality.subsumes(n2, n3);
        }
        if ((n = Type.relationship(itemType2, itemType)) == 4) {
            if (Cardinality.allowsZero(n3) && Cardinality.allowsZero(n2)) {
                if (n3 != 256) {
                    object = "Required item type of " + roleLocator.getMessage() + " is " + itemType.toString(staticContext.getNamePool()) + "; supplied value has item type " + itemType2.toString(staticContext.getNamePool()) + ". The expression can succeed only if the supplied value is an empty sequence.";
                    staticContext.issueWarning((String)object);
                }
            } else {
                object = new StaticError("Required item type of " + roleLocator.getMessage() + " is " + itemType.toString(staticContext.getNamePool()) + "; supplied value has item type " + itemType2.toString(staticContext.getNamePool()), ExpressionTool.getLocator((Expression)expressionArray));
                ((XPathException)object).setErrorCode(roleLocator.getErrorCode());
                ((XPathException)object).setIsTypeError(true);
                throw object;
            }
        }
        if (n != 0 && n != 2) {
            object = new ItemChecker((Expression)object2, itemType, roleLocator);
            ((ComputedExpression)object).adoptChildExpression((Expression)object2);
            object2 = object;
        }
        if (!bl3) {
            if (object2 instanceof Value) {
                object = new StaticError("Required cardinality of " + roleLocator.getMessage() + " is " + Cardinality.toString(n2) + "; supplied value has cardinality " + Cardinality.toString(n3), ExpressionTool.getLocator((Expression)expressionArray));
                ((XPathException)object).setIsTypeError(true);
                ((XPathException)object).setErrorCode(roleLocator.getErrorCode());
                throw object;
            }
            object = new CardinalityChecker((Expression)object2, n2, roleLocator);
            ((ComputedExpression)object).adoptChildExpression((Expression)object2);
            object2 = object;
        }
        return object2;
    }
}

