/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class RangeVariableDeclaration
implements VariableDeclaration {
    private int nameCode;
    private SequenceType requiredType;
    private String variableName;
    private List references = new ArrayList();

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public void fixupReferences(Binding binding) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            BindingReference bindingReference = (BindingReference)iterator.next();
            bindingReference.setStaticType(this.requiredType, null, 0);
            bindingReference.fixup(binding);
        }
    }

    public void refineTypeInformation(ItemType itemType, int n, Value value, int n2) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            int n3;
            ItemType itemType2;
            BindingReference bindingReference = (BindingReference)iterator.next();
            if (!(bindingReference instanceof VariableReference)) continue;
            ItemType itemType3 = itemType2 = ((VariableReference)bindingReference).getItemType();
            if (Type.isSubType(itemType, itemType2)) {
                itemType3 = itemType;
            }
            if ((n3 = n & ((VariableReference)bindingReference).getCardinality()) == 0) {
                n3 = ((VariableReference)bindingReference).getCardinality();
            }
            SequenceType sequenceType = new SequenceType(itemType3, n3);
            bindingReference.setStaticType(sequenceType, value, n2);
        }
    }
}

