/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.sort.DocumentSorter;
import net.sf.saxon.sort.Reverser;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class PromotionOffer {
    public static final int FOCUS_INDEPENDENT = 10;
    public static final int RANGE_INDEPENDENT = 11;
    public static final int INLINE_VARIABLE_REFERENCES = 12;
    public static final int UNORDERED = 13;
    public int action;
    public boolean promoteDocumentDependent = false;
    public boolean mustEliminateDuplicates = true;
    public Binding binding;
    public Expression containingExpression;

    public Expression accept(Expression expression) throws XPathException {
        switch (this.action) {
            case 11: {
                if (PromotionOffer.dependsOnVariable(expression, this.binding)) break;
                return this.promote(expression);
            }
            case 10: {
                int n = expression.getDependencies();
                if ((n & 0x1E) == 0) {
                    return this.promote(expression);
                }
                if (!this.promoteDocumentDependent || (n & 0xE) != 0) break;
                return this.promote(expression);
            }
            case 12: {
                if (!(expression instanceof VariableReference) || ((VariableReference)expression).getBinding() != this.binding) break;
                return this.containingExpression;
            }
            case 13: {
                if (expression instanceof Reverser) {
                    return ((Reverser)expression).getBaseExpression();
                }
                if (!(expression instanceof DocumentSorter) || this.mustEliminateDuplicates) break;
                return ((DocumentSorter)expression).getBaseExpression();
            }
            default: {
                throw new UnsupportedOperationException("Unknown promotion action " + this.action);
            }
        }
        return null;
    }

    private Expression promote(Expression expression) {
        RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
        rangeVariableDeclaration.setVariableName("zz:" + rangeVariableDeclaration.hashCode());
        SequenceType sequenceType = new SequenceType(expression.getItemType(), expression.getCardinality());
        rangeVariableDeclaration.setRequiredType(sequenceType);
        VariableReference variableReference = new VariableReference(rangeVariableDeclaration);
        ExpressionTool.copyLocationInfo(this.containingExpression, variableReference);
        variableReference.setParentExpression((ComputedExpression)this.containingExpression);
        Container container = this.containingExpression.getParentExpression();
        LetExpression letExpression = new LetExpression();
        letExpression.setVariableDeclaration(rangeVariableDeclaration);
        letExpression.setSequence(expression);
        letExpression.setAction(this.containingExpression);
        letExpression.setParentExpression(container);
        letExpression.adoptChildExpression(this.containingExpression);
        this.containingExpression = letExpression;
        return variableReference;
    }

    private static boolean dependsOnVariable(Expression expression, Binding binding) {
        if (expression instanceof VariableReference) {
            return ((VariableReference)expression).getBinding() == binding;
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            if (!PromotionOffer.dependsOnVariable(expression2, binding)) continue;
            return true;
        }
        return false;
    }
}

