/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public abstract class Assignation
extends ComputedExpression
implements Binding {
    protected int slotNumber = -999;
    protected Expression sequence;
    protected Expression action;
    protected String variableName;
    protected int nameCode;
    protected transient RangeVariableDeclaration declaration;

    public void setVariableDeclaration(RangeVariableDeclaration rangeVariableDeclaration) {
        this.declaration = rangeVariableDeclaration;
        this.nameCode = rangeVariableDeclaration.getNameCode();
        this.variableName = rangeVariableDeclaration.getVariableName();
    }

    public void setAction(Expression expression) {
        this.action = expression;
        this.declaration.fixupReferences(this);
        this.adoptChildExpression(expression);
    }

    public void setSequence(Expression expression) {
        this.sequence = expression;
        this.adoptChildExpression(expression);
    }

    public void setSlotNumber(int n) {
        this.slotNumber = n;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.simplify(staticContext);
        this.action = this.action.simplify(staticContext);
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.sequence = this.sequence.promote(promotionOffer);
        if (promotionOffer.action == 12 || promotionOffer.action == 13) {
            this.action = this.action.promote(promotionOffer);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.sequence, this.action);
    }

    public int getVariableNameCode() {
        return this.nameCode;
    }

    public int getVariableFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public String getVariableName(NamePool namePool) {
        String string;
        String string2 = string = this.slotNumber == -999 ? "unallocated" : this.slotNumber + "";
        if (this.variableName == null) {
            return "zz:var" + this.hashCode() + " [" + string + ']';
        }
        return this.variableName + " [" + string + ']';
    }

    public Value evaluateVariable(XPathContext xPathContext) throws XPathException {
        return xPathContext.evaluateLocalVariable(this.slotNumber);
    }
}

