/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class SequenceOutputter
extends SequenceReceiver {
    private List list = new ArrayList();
    private Configuration config;
    private NamePool namePool;
    private String systemId;
    private Receiver tree = null;
    private TinyBuilder builder = null;
    private int elementLevel = 0;
    private int documentLevel = 0;
    private boolean inStartTag = false;
    private static final int[] treeSizeParameters = new int[]{50, 10, 5, 200};

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public final void open() throws XPathException {
    }

    public void startDocument(int n) throws XPathException {
        if (this.tree == null) {
            this.builder = new TinyBuilder();
            this.builder.setConfiguration(this.config);
            this.builder.setSizeParameters(treeSizeParameters);
            NamespaceReducer namespaceReducer = new NamespaceReducer();
            namespaceReducer.setUnderlyingReceiver(this.builder);
            namespaceReducer.setConfiguration(this.config);
            ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter();
            complexContentOutputter.setConfiguration(this.config);
            complexContentOutputter.setReceiver(namespaceReducer);
            complexContentOutputter.setDocumentLocator(this.locator);
            this.tree = complexContentOutputter;
            this.tree.setSystemId(this.systemId);
            this.tree.setConfiguration(this.config);
            this.tree.open();
            this.tree.startDocument(n);
        }
        ++this.documentLevel;
    }

    public void endDocument() throws XPathException {
        --this.documentLevel;
        if (this.documentLevel == 0) {
            this.tree.endDocument();
            this.tree.close();
            DocumentInfo documentInfo = this.builder.getCurrentDocument();
            this.tree = null;
            this.builder = null;
            this.append(documentInfo, 0);
        }
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.tree == null) {
            this.documentLevel = 0;
            this.builder = new TinyBuilder();
            this.builder.setConfiguration(this.config);
            this.builder.setSizeParameters(treeSizeParameters);
            this.builder.setDocumentLocator(this.locator);
            NamespaceReducer namespaceReducer = new NamespaceReducer();
            namespaceReducer.setUnderlyingReceiver(this.builder);
            namespaceReducer.setConfiguration(this.config);
            namespaceReducer.setDocumentLocator(this.locator);
            ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter();
            complexContentOutputter.setConfiguration(this.config);
            complexContentOutputter.setReceiver(namespaceReducer);
            complexContentOutputter.setDocumentLocator(this.locator);
            this.tree = complexContentOutputter;
            this.tree.setSystemId(this.systemId);
            this.tree.setConfiguration(this.config);
            this.tree.open();
            this.tree.startElement(n, n2, n3, n4);
        } else {
            this.tree.startElement(n, n2, n3, n4);
        }
        ++this.elementLevel;
        this.inStartTag = true;
        this.previousAtomic = false;
    }

    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        --this.elementLevel;
        if (this.elementLevel == 0 && this.documentLevel == 0) {
            this.tree.endElement();
            this.tree.close();
            DocumentInfo documentInfo = this.builder.getCurrentDocument();
            this.tree = null;
            this.builder = null;
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)3);
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            ((TinyDocumentImpl)documentInfo).setRootNode(nodeInfo);
            this.append(nodeInfo, 0);
        } else {
            this.tree.endElement();
        }
        this.previousAtomic = false;
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.tree == null) {
            Orphan orphan = new Orphan(this.namePool);
            orphan.setNodeKind((short)13);
            orphan.setNameCode(this.namePool.allocate("", "", this.namePool.getPrefixFromNamespaceCode(n)));
            orphan.setStringValue(this.namePool.getURIFromNamespaceCode(n));
            this.append(orphan, 0);
        } else {
            this.tree.namespace(n, n2);
        }
        this.previousAtomic = false;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.tree == null) {
            Orphan orphan = new Orphan(this.namePool);
            orphan.setNodeKind((short)2);
            orphan.setNameCode(n);
            orphan.setStringValue(charSequence);
            orphan.setTypeAnnotation(n2);
            this.append(orphan, n3);
        } else {
            this.tree.attribute(n, n2, charSequence, n3, n4);
        }
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        this.inStartTag = false;
        this.tree.startContent();
        this.previousAtomic = false;
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.tree == null) {
            Orphan orphan = new Orphan(this.namePool);
            orphan.setNodeKind((short)3);
            orphan.setStringValue(charSequence);
            this.append(orphan, n);
        } else {
            this.tree.characters(charSequence, n, n2);
        }
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.tree == null) {
            Orphan orphan = new Orphan(this.namePool);
            orphan.setNodeKind((short)8);
            orphan.setStringValue(charSequence);
            this.append(orphan, n);
        } else {
            this.tree.comment(charSequence, n, n2);
        }
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.tree == null) {
            Orphan orphan = new Orphan(this.namePool);
            orphan.setNameCode(this.namePool.allocate("", "", string));
            orphan.setNodeKind((short)7);
            orphan.setStringValue(charSequence);
            this.append(orphan, n);
        } else {
            this.tree.processingInstruction(string, charSequence, n, n2);
        }
        this.previousAtomic = false;
    }

    public void close() throws XPathException {
        this.previousAtomic = false;
    }

    public void append(Item item, int n) throws XPathException {
        if (item == null) {
            return;
        }
        if (this.tree != null && this.previousAtomic && item instanceof AtomicValue) {
            this.tree.characters(" ", 0, 0);
        }
        this.previousAtomic = item instanceof AtomicValue;
        if (this.tree == null) {
            this.list.add(item);
        } else if (item instanceof AtomicValue) {
            this.tree.characters(item.getStringValue(), 0, 0);
        } else {
            ((NodeInfo)item).copy(this.tree, 2, true, n);
        }
    }

    public Value getSequence() {
        switch (this.list.size()) {
            case 0: {
                return EmptySequence.getInstance();
            }
            case 1: {
                Item item = (Item)this.list.get(0);
                return Value.asValue(item);
            }
        }
        return new SequenceExtent(this.list);
    }

    public Item getFirstItem() {
        if (this.list.size() == 0) {
            return null;
        }
        return (Item)this.list.get(0);
    }
}

