Params = {}
function Params.parse_line(line)
	local result = ''
	for k, v in string.gfind(line, "([.%w]+)%s*=%s*(.+)") do
		if type(tonumber(v))=="number" then
			result = " --param " .. k .. " " .. v
		else
			v = string.gsub(v, "(.-)%s*$", "%1")
			result = " --stringparam " .. k .. " \"" .. v .. "\""
		end
	end
	return result
end

function Params.get_params(filename)
	f = io.open(filename, "r")
	if f then
		local result = ''
		for line in f:lines() do
			if string.sub(line, 1, 1) ~= '#' then -- # ּ
				result = result .. Params.parse_line(line)
			end
		end
		f:close()
		return result
	end
end
