/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.awt.Color;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.SpaceProperty;
import org.xml.sax.Locator;

public class PageNumber
extends FObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonFont commonFont;
    private CommonMarginInline commonMarginInline;
    private CommonRelativePosition commonRelativePosition;
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private int dominantBaseline;
    private String id;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private SpaceProperty lineHeight;
    private int scoreSpaces;
    private Length textAltitude;
    private CommonTextDecoration textDecoration;
    private Length textDepth;
    private int textTransform;
    private int visibility;
    private SpaceProperty wordSpacing;
    private int wrapOption;
    private Color color;

    public PageNumber(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonFont = pList.getFontProps();
        this.commonMarginInline = pList.getMarginInlineProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.alignmentAdjust = pList.get(3).getLength();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.dominantBaseline = pList.get(82).getEnum();
        this.id = pList.get(113).getString();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.lineHeight = pList.get(131).getSpace();
        this.scoreSpaces = pList.get(195).getEnum();
        this.textAltitude = pList.get(225).getLength();
        this.textDecoration = pList.getTextDecorationProps();
        this.textDepth = pList.get(227).getLength();
        this.textTransform = pList.get(230).getEnum();
        this.visibility = pList.get(235).getEnum();
        this.wordSpacing = pList.get(243).getSpace();
        this.wrapOption = pList.get(244).getEnum();
        this.color = pList.get(66).getColor(this.getUserAgent());
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
        this.getFOEventHandler().startPageNumber(this);
    }

    protected void endOfNode() throws FOPException {
        this.getFOEventHandler().endPageNumber(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public CommonFont getCommonFont() {
        return this.commonFont;
    }

    public Color getColor() {
        return this.color;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getId() {
        return this.id;
    }

    public CommonTextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public String getLocalName() {
        return "page-number";
    }

    public int getNameId() {
        return 30;
    }
}

