/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.HashMap;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertyListMaker;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.Property;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class Marker
extends FObjMixed {
    private String markerClassName;
    private PropertyListMaker savePropertyListMaker;
    private HashMap descendantPropertyLists = new HashMap();

    public Marker(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        if (this.findAncestor(11) < 0) {
            this.invalidChildError(this.locator, "http://www.w3.org/1999/XSL/Format", "marker", "An fo:marker is permitted only as the descendant of an fo:flow");
        }
        this.markerClassName = pList.get(139).getString();
        if (this.markerClassName == null || this.markerClassName.equals("")) {
            this.missingPropertyError("marker-class-name");
        }
    }

    protected MarkerPropertyList getPropertyListFor(FONode foNode) {
        return (MarkerPropertyList)this.descendantPropertyLists.get(foNode);
    }

    protected void startOfNode() {
        FOEventHandler foEventHandler = this.getFOEventHandler();
        this.savePropertyListMaker = foEventHandler.getPropertyListMaker();
        foEventHandler.setPropertyListMaker(new PropertyListMaker(){

            public PropertyList make(FObj fobj, PropertyList parentPropertyList) {
                MarkerPropertyList pList = new MarkerPropertyList(fobj, parentPropertyList);
                Marker.this.descendantPropertyLists.put(fobj, pList);
                return pList;
            }
        });
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().setPropertyListMaker(this.savePropertyListMaker);
        this.savePropertyListMaker = null;
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (!this.isBlockOrInlineItem(nsURI, localName)) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected boolean inMarker() {
        return true;
    }

    public String getMarkerClassName() {
        return this.markerClassName;
    }

    public String getLocalName() {
        return "marker";
    }

    public int getNameId() {
        return 24;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" {").append(this.getMarkerClassName()).append("}");
        return sb.toString();
    }

    protected class MarkerPropertyList
    extends PropertyList
    implements Attributes {
        private MarkerAttribute[] attribs;

        public MarkerPropertyList(FObj fobj, PropertyList parentPropertyList) {
            super(fobj, null);
        }

        public void addAttributesToList(Attributes attributes) throws ValidationException {
            this.attribs = new MarkerAttribute[attributes.getLength()];
            int i = attributes.getLength();
            while (--i >= 0) {
                String namespace = attributes.getURI(i);
                String qname = attributes.getQName(i);
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                this.attribs[i] = new MarkerAttribute(namespace, qname, name, value);
            }
        }

        public void putExplicit(int propId, Property value) {
        }

        public Property getExplicit(int propId) {
            return null;
        }

        public int getLength() {
            if (this.attribs == null) {
                return 0;
            }
            return this.attribs.length;
        }

        public String getURI(int index) {
            if (this.attribs != null && index < this.attribs.length && index >= 0 && this.attribs[index] != null) {
                return this.attribs[index].namespace;
            }
            return null;
        }

        public String getLocalName(int index) {
            if (this.attribs != null && index < this.attribs.length && index >= 0 && this.attribs[index] != null) {
                return this.attribs[index].name;
            }
            return null;
        }

        public String getQName(int index) {
            if (this.attribs != null && index < this.attribs.length && index >= 0 && this.attribs[index] != null) {
                return this.attribs[index].qname;
            }
            return null;
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getValue(int index) {
            if (this.attribs != null && index < this.attribs.length && index >= 0 && this.attribs[index] != null) {
                return this.attribs[index].value;
            }
            return null;
        }

        public int getIndex(String name, String namespace) {
            int index;
            block1: {
                index = -1;
                if (this.attribs == null || name == null || namespace == null) break block1;
                int i = this.attribs.length;
                while (!(--i < 0 || this.attribs[i] != null && namespace.equals(this.attribs[i].namespace) && name.equals(this.attribs[i].name))) {
                }
            }
            return index;
        }

        public int getIndex(String qname) {
            int index;
            block1: {
                index = -1;
                if (this.attribs == null || qname == null) break block1;
                int i = this.attribs.length;
                while (!(--i < 0 || this.attribs[i] != null && qname.equals(this.attribs[i].qname))) {
                }
            }
            return index;
        }

        public String getType(String name, String namespace) {
            return "CDATA";
        }

        public String getType(String qname) {
            return "CDATA";
        }

        public String getValue(String name, String namespace) {
            int index = this.getIndex(name, namespace);
            if (index > 0) {
                return this.getValue(index);
            }
            return null;
        }

        public String getValue(String qname) {
            int index = this.getIndex(qname);
            if (index > 0) {
                return this.getValue(index);
            }
            return null;
        }

        protected class MarkerAttribute {
            protected String namespace;
            protected String qname;
            protected String name;
            protected String value;

            public MarkerAttribute(String namespace, String qname, String name, String value) {
                this.namespace = namespace;
                this.qname = qname;
                this.name = name == null ? qname : name;
                this.value = value;
            }

            public MarkerAttribute(String name, String value) {
                this.namespace = null;
                this.qname = name;
                this.name = name;
                this.value = value;
            }
        }
    }
}

