/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.awt.Color;
import java.util.NoSuchElementException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.SpaceProperty;
import org.xml.sax.Locator;

public class Character
extends FObj {
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonFont commonFont;
    private CommonHyphenation commonHyphenation;
    private CommonMarginInline commonMarginInline;
    private CommonRelativePosition commonRelativePosition;
    private Length alignmentAdjust;
    private int treatAsWordSpace;
    private int alignmentBaseline;
    private Length baselineShift;
    private char character;
    private Color color;
    private int dominantBaseline;
    private Length textDepth;
    private Length textAltitude;
    private String id;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private Property letterSpacing;
    private SpaceProperty lineHeight;
    private int scoreSpaces;
    private int suppressAtLineBreak;
    private CommonTextDecoration textDecoration;
    private int textTransform;
    private int visibility;
    private Property wordSpacing;
    public static final int OK = 0;
    public static final int DOESNOT_FIT = 1;

    public Character(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonFont = pList.getFontProps();
        this.commonHyphenation = pList.getHyphenationProps();
        this.commonMarginInline = pList.getMarginInlineProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.alignmentAdjust = pList.get(3).getLength();
        this.treatAsWordSpace = pList.get(232).getEnum();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.character = pList.get(63).getCharacter();
        this.color = pList.get(66).getColor(this.getUserAgent());
        this.dominantBaseline = pList.get(82).getEnum();
        this.textDepth = pList.get(227).getLength();
        this.textAltitude = pList.get(225).getLength();
        this.id = pList.get(113).getString();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.letterSpacing = pList.get(128);
        this.lineHeight = pList.get(131).getSpace();
        this.scoreSpaces = pList.get(195).getEnum();
        this.suppressAtLineBreak = pList.get(215).getEnum();
        this.textDecoration = pList.getTextDecorationProps();
        this.textTransform = pList.get(230).getEnum();
        this.visibility = pList.get(235).getEnum();
        this.wordSpacing = pList.get(243);
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
        this.getFOEventHandler().character(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public CharIterator charIterator() {
        return new FOCharIterator(this);
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public CommonFont getCommonFont() {
        return this.commonFont;
    }

    public CommonHyphenation getCommonHyphenation() {
        return this.commonHyphenation;
    }

    public char getCharacter() {
        return this.character;
    }

    public Color getColor() {
        return this.color;
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public String getId() {
        return this.id;
    }

    public Property getLetterSpacing() {
        return this.letterSpacing;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public CommonTextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    public Property getWordSpacing() {
        return this.wordSpacing;
    }

    public String getLocalName() {
        return "character";
    }

    public int getNameId() {
        return 5;
    }

    private class FOCharIterator
    extends CharIterator {
        private boolean bFirst = true;
        private Character foChar;

        FOCharIterator(Character foChar) {
            this.foChar = foChar;
        }

        public boolean hasNext() {
            return this.bFirst;
        }

        public char nextChar() {
            if (this.bFirst) {
                this.bFirst = false;
                return this.foChar.character;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            this.foChar.character = '\u0000';
            Character.this.getFOEventHandler().getXMLWhiteSpaceHandler().addDiscardableFOChar(this.foChar);
        }

        public void replaceChar(char c) {
            this.foChar.character = c;
        }
    }
}

