/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.JpegImage;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSImageUtils
extends org.apache.xmlgraphics.ps.PSImageUtils {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$render$ps$PSImageUtils == null ? (class$org$apache$fop$render$ps$PSImageUtils = PSImageUtils.class$("org.apache.fop.render.ps.PSImageUtils")) : class$org$apache$fop$render$ps$PSImageUtils);
    static /* synthetic */ Class class$org$apache$fop$render$ps$PSImageUtils;

    public static void renderBitmapImage(FopImage img, float x, float y, float w, float h, PSGenerator gen) throws IOException {
        if (img instanceof JpegImage) {
            if (!img.load(2)) {
                gen.commentln("%JPEG image could not be processed: " + img);
                return;
            }
        } else if (!img.load(4)) {
            gen.commentln("%Bitmap image could not be processed: " + img);
            return;
        }
        byte[] imgmap = img.getBitmapsSize() > 0 ? img.getBitmaps() : img.getRessourceBytes();
        String imgName = img.getMimeType() + " " + img.getOriginalURI();
        Dimension imgDim = new Dimension(img.getWidth(), img.getHeight());
        Rectangle2D.Double targetRect = new Rectangle2D.Double(x, y, w, h);
        boolean isJPEG = img instanceof JpegImage;
        PSImageUtils.writeImage(imgmap, imgDim, imgName, targetRect, isJPEG, img.getColorSpace(), gen);
    }

    public static void renderEPS(EPSImage img, float x, float y, float w, float h, PSGenerator gen) {
        try {
            if (!img.load(2)) {
                gen.commentln("%EPS image could not be processed: " + img);
                return;
            }
            int[] bbox = img.getBBox();
            int bboxw = bbox[2] - bbox[0];
            int bboxh = bbox[3] - bbox[1];
            String name = img.getDocName();
            if (name == null || name.length() == 0) {
                name = img.getOriginalURI();
            }
            PSImageUtils.renderEPS(img.getEPSImage(), name, x, y, w, h, bbox[0], bbox[1], bboxw, bboxh, gen);
        }
        catch (Exception e) {
            log.error("PSRenderer.renderImageArea(): Error rendering bitmap (" + e.getMessage() + ")", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

