/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.IOException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.render.ps.NativeTextHandler;
import org.apache.fop.render.ps.PSTextElementBridge;
import org.apache.fop.render.ps.PSTextPainter;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.AbstractPSDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.ps.TextHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractPSTranscoder
extends AbstractFOPTranscoder {
    private Configuration cfg = null;
    protected AbstractPSDocumentGraphics2D graphics = null;

    protected abstract AbstractPSDocumentGraphics2D createDocumentGraphics2D();

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        this.graphics = this.createDocumentGraphics2D();
        if (!this.isTextStroked()) {
            FontInfo fontInfo = new FontInfo();
            FontSetup.setup(fontInfo, null, null);
            this.graphics.setCustomTextHandler(new NativeTextHandler(this.graphics, fontInfo));
        }
        super.transcode(document, uri, output);
        this.getLogger().trace("document size: " + this.width + " x " + this.height);
        UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)this.ctx, (Element)document.getDocumentElement());
        float widthInPt = UnitProcessor.userSpaceToSVG((float)this.width, (short)9, (short)2, (UnitProcessor.Context)uctx);
        int w = (int)((double)widthInPt + 0.5);
        float heightInPt = UnitProcessor.userSpaceToSVG((float)this.height, (short)9, (short)2, (UnitProcessor.Context)uctx);
        int h = (int)((double)heightInPt + 0.5);
        this.getLogger().trace("document size: " + w + "pt x " + h + "pt");
        try {
            this.graphics.setupDocument(output.getOutputStream(), w, h);
            this.graphics.setViewportDimension(this.width, this.height);
            if (this.hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                this.graphics.setBackgroundColor((Color)this.hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR));
            }
            this.graphics.setGraphicContext(new GraphicContext());
            this.graphics.setTransform(this.curTxf);
            this.root.paint((Graphics2D)this.graphics);
            this.graphics.finish();
        }
        catch (IOException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }

    protected boolean isTextStroked() {
        boolean stroke = false;
        if (this.hints.containsKey((Object)KEY_STROKE_TEXT)) {
            stroke = (Boolean)this.hints.get((Object)KEY_STROKE_TEXT);
        }
        return stroke;
    }

    protected BridgeContext createBridgeContext() {
        TextHandler handler;
        BridgeContext ctx = new BridgeContext(this.userAgent);
        if (!this.isTextStroked() && (handler = this.graphics.getCustomTextHandler()) instanceof NativeTextHandler) {
            NativeTextHandler nativeTextHandler = (NativeTextHandler)handler;
            PSTextPainter textPainter = new PSTextPainter(nativeTextHandler);
            ctx.setTextPainter((TextPainter)textPainter);
            ctx.putBridge((Bridge)new PSTextElementBridge(textPainter));
        }
        return ctx;
    }
}

