<?php // -*-php-*-
rcs_id('$Id: TitleSearch.php,v 1.4 2004/03/25 08:15:44 gryu Exp $');

require_once('lib/TextSearchQuery.php');

/**
 */
class WikiPlugin_TitleSearch
extends	WikiPlugin
{
	var	$name =	'TitleSearch';
	
	function getDefaultArguments() {
		// FIXME: how to exclude multiple pages?
		return array('s' => false,
					 'auto_redirect' => false,
					 'noheader'	=> false
					 );
	}

	function getDefaultFormArguments() {
		$defaults =	parent::getDefaultFormArguments();
		$defaults['description'] =_T('title_search');
		$defaults['buttontext'] = _T('title_search');
		return $defaults;
	}
	
	function run($dbi, $argstr,	$request) {
		$args =	$this->getArgs($argstr,	$request);
		if (empty($args['s']))
			return '';

		extract($args);
		$s = preg_replace('/\'(.*)\'/', '\\1', $s);
		$query = new TextSearchQuery($s); 
		$pages = $dbi->titleSearch($query);
		$lines = array();
		while ($page = $pages->next()) {
			$name =	$page->getName();
			$lines[] = Element('li', LinkExistingWikiWord($name));
			$last_name = $name;
		}

		if ($auto_redirect && count($lines)	== 1)
			$request->redirect(WikiURL($last_name));

		$html =	'';
		if (!$noheader)
			$html .= QElement('p',
				  sprintf(_T('title_search_result'), $s)); 
		if ($lines)
			$html .= Element('ul', join("\n", $lines));
		else

			$html .= '<p>' . _T('no_such_page') . LinkUnknownWikiWord($s).'</p>';
		
		return $html;
	}
};
		
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:	  
?>
