<?php // -*-php-*-
rcs_id('$Id: ChangeMonitor.php,v 1.2 2004/03/25 08:15:44 gryu Exp $');
/**
 */
class WikiPlugin_ChangeMonitor
extends WikiPlugin
{
    var $name = 'ChangeMonitor';
  
    function getDefaultArguments() {
        // FIXME: how to exclude multiple pages?
        return array('exclude'		=> '',
                     'include_self'	=> 0,
                     'noheader'		=> 0,
                     'page'		=> false,
                     'recent' => 1,
                     );
    }
    
	function getDefaultFormArguments() {
		$defaults =	parent::getDefaultFormArguments();
		$defaults['description'] = 'ChangeMonitor ';
		$defaults['buttontext'] = 'ChangeMonitor';
		$defaults['textinput'] = 'page';
		return $defaults;
	}

    function run($dbi, $argstr, $request) {
        $args = $this->getArgs($argstr, $request);
        extract($args);
        					
        if (!$page)
            return '';
        $bkpages = array();
        $p = $dbi->getPage($page);
        $backlinks = $p->getLinks();
        $lines = array();

        $backlink_pages = array();
        
        while ($backlink = $backlinks->next()) {
            $name = $backlink->getName();
            if ($exclude && $name == $exclude)
                continue;
            if (!$include_self && $name == $page)
                continue;
            $backlink_pages[] = $name;
        }
        
        $diffargs =	array('action' => 'diff');
	$params	= array('days' => $recent, 'include_minor_revisions' => false,
				'exclude_major_revisions' => false,
				'include_all_revisions'	=> true);
	if ($recent >	0.0) {
			$params['since'] = time() -	24 * 3600 *	$recent;
	}
				
        	$changes = $dbi->mostRecent($params);

	global $dateformat, $datetimeformat;
	global $WikiNameRegexp;
	$currdate = '';
        while ($rev = $changes->next())
        {
		$currpage =	$rev->getPage();
		$pagename =	$currpage->getName();		

            	if ( in_array($pagename, $backlink_pages) )
            	{
			$created = $rev->get('mtime');
			$date = strftime($dateformat, $created);
			$time = strftime('%I:%M %p', $created);
			if ($date != $currdate)
			{
				$lines[] = '<tr><td colspan="3">' . "$date </td></tr>\n";
				$currdate = $date;
			}

            		$lines[] = '<tr><td>&nbsp;&nbsp;</td><td>' .
            			QElement('a',  array('href' => WikiURL($pagename , $diffargs)),
					 _T('diff') ) . ' ' .
            				LinkWikiWord($pagename )  . "</td><td>$time</td></tr>\n";
            	}

        	}

        $html = '<table class="toc">';
        if (!$noheader) {
            $fs = $lines
                 ? _T( 'changed_pages_link_to_this_for_n_days') //gryu* gettext
                 : _T('no_changed_page_link_to_this'); //gryu* gettext
            $header = sprintf(htmlspecialchars($fs),
                              LinkExistingWikiWord($page), $recent);
            $html .= "<td colspan='3'> $header </td>\n";
        }
        
        return $html . Element('ul', join("\n", $lines)) . '</table>';
    }
};

// For emacs users
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:
        
?>
