<?php

/*
	  Standard functions for Wiki functionality
function StartTag($tag, $args = '')
function Element($tag, $args = '', $content = '')
function QElement($tag, $args = '', $content = '')
function LinkURL($url, $linktext='') {
function LinkInternalRef($wikiword, $linktext='') {
function LinkImage($url, $alt='[External Image]') {
function CookSpaces($pagearray) {
function ParseAndLink($bracketlink) {

 */

function StartTag($tag, $args = '')
{
	$s = "<$tag";
	if (is_array($args))
	{
		while (list($key, $val) = each($args))
		{
			if (is_string($val) || is_numeric($val))
				$s .= sprintf(' %s="%s"', $key, htmlspecialchars($val));
			else if ($val)
				$s .= " $key";
		}
	}
	return "$s>";
}

   
define('NO_END_TAG_PAT',
	 '/^' . join('|', array('area', 'base', 'basefont',
	'br', 'col', 'frame',
	'hr', 'image', 'input',
	'isindex', 'link', 'meta',
	'param')) . '$/i');
	
function Element($tag, $args = '', $content = '')
{
	$html = "<$tag";
	if (!is_array($args))
	{
		$content = $args;
		$args = false;
	}
	$html = StartTag($tag, $args);

	$html .= $content;
	$html .= "</$tag>";//FIXME: newline might not always be desired.
	return $html;
}

function QElement($tag, $args = '', $content = '')
{
	if (is_array($args))
		return Element($tag, $args, htmlspecialchars($content));
 	else
 	{
		$content = $args;
		return Element($tag, htmlspecialchars($content));
	}
}

function LinkURL($url, $linktext='') {
	// FIXME: Is this needed (or sufficient?)
	if(ereg("[<>\"]", $url)) {
		return "<b><u>BAD URL -- remove all of &lt;, &gt;, &quot;</u></b>";
	}
	
	if (empty($linktext)) {
		$linktext = $url;
	}
	return QElement('ulink',
		array('url' => $url),
		$linktext);
}

function LinkInternalRef($wikiword, $linktext='') {
	if (empty($linktext)) {
		$linktext = $wikiword;
	} 

	return QElement('link', array('linkend' => $wikiword), $linktext);
}

function LinkImage($url, $alt='[External Image]') {
	// FIXME: Is this needed (or sufficient?)
	//  As long as the src in htmlspecialchars()ed I think it's safe.
	if(ereg('[<>"]', $url)) {
		return "<b><u>BAD URL -- remove all of &lt;, &gt;, &quot;</u></b>";
	}
	return '<inlinemediaobject>
<imageobject>
<imagedata fileref="'. $url . '"/>
</imageobject>
</inlinemediaobject>';
}

// converts spaces to tabs
function CookSpaces($pagearray) {
  return preg_replace("/ {3,8}/", "\t", $pagearray);
}


class Stack {
  var $items = array();
  var $size = 0;

  function push($item) {
	 $this->items[$this->size] = $item;
	 $this->size++;
	 return true;
  }  

  function pop() {
	 if ($this->size == 0) {
		return false; // stack is empty
	 }  
	 $this->size--;
	 return $this->items[$this->size];
  }  

  function cnt() {
	 return $this->size;
  }  

  function top() {
	 if($this->size)
		return $this->items[$this->size - 1];
	 else
		return '';
  }  

}  
// end class definition

function ParseAndLink($bracketlink) {
	global $AllowedProtocols, $InlineImages;
	global $InterWikiLinkRegexp;

	// $bracketlink will start and end with brackets; in between
	// will be either a page name, a URL or both separated by a pipe.

	// strip brackets and leading space
	preg_match("/(\[\s*)(.+?)(\s*\])/", $bracketlink, $match);
	// match the contents 
	preg_match("/([^|]+)(\|)?([^|]+)?/", $match[2], $matches);

	if (isset($matches[3])) {
		// named link of the form  "[some link name | http://blippy.com/]"
		$URL = trim($matches[3]);
		$linkname = trim($matches[1]);
		$linktype = 'named';
	}
	else
	{
		// unnamed link of the form "[http://blippy.com/] or [wiki page]"
		$URL = trim($matches[1]);
		$linkname = '';
		$linktype = 'simple';
	}

	if ($linkname == '' && preg_match("/($InlineImages)$/i", $URL)) {
		$link['type'] = "image-$linktype";
		$link['link'] = LinkImage($URL, $linkname);
	} 
	elseif (preg_match("#^($AllowedProtocols):#", $URL) )
	{
		// if it's an image, embed it; otherwise, it's a regular link
		$link['type'] = "url-$linktype";
			$link['link'] = LinkURL($URL, $linkname);
	} 
	elseif ( preg_match("#^DocBook:(.*)#", $URL, $match) )
	{
		$link['link'] = LinkInternalRef($match[1], $linkname);
	}		
	else
		$link['link'] = LinkInternalRef($URL, $linkname);
	return $link;
}

?>
