<?php
function DebugInfo($aVarName)
{
	echo '<pre>';
	echo $aVarName . "\n";
	print_r($$aVarName);
	echo '</pre>';
}

class FileSysInfo 
{
	var $RequestedPath; //   URL
	var $CurrentDirPath; //  丮  
	var $RootPhysicalPath; // Ʈ  
	var $PhysicalPath; //  丮  
	var $CurrDirName; // 丮̸
	var $PrevPath; // 丮 URL
	var $PathComponents; //   丮 ̸ 迭
	var $isTopLevel; //  ΰ ֻ 
	function FileSysInfo($rootName = 'ó')
	{

		$ServerVars = &$_SERVER;
		//$ServerVars = &$HTTP_SERVER_VARS;
		$a = explode('/', $ServerVars['SCRIPT_FILENAME']);
		array_pop($a);
		$this->RootPhysicalPath = join('/', $a);
		$a = explode('/', $ServerVars['SCRIPT_NAME']);
		array_pop($a);

		$this->ScriptRootPath =  join('/', $a);
		$this->ScriptName = $ServerVars['SCRIPT_NAME'];
		$this->PrevPath = $this->ScriptName ;
		$this->RequestedPath = $ServerVars['SCRIPT_NAME'];
		$subdir = trim( $ServerVars['PATH_INFO'] );

		$this->isTopLevel = false;
		$this->PathComponents = array();
		if ( $subdir != '' ) 
		{
			str_replace('..', '__', $subdir );// -.-
			$subdirs = explode('/', $subdir);
			for ($i = 0; $i < count($subdirs) ; ++$i)
			{
				if (trim( $subdirs[$i]) != '')
				{
					$PathComponents[] = $subdirs[$i];
				}
			}
		}
		$this->PhysicalPath = $this->RootPhysicalPath;
		$this->CurrentDirPath = $this->ScriptRootPath;
		
		if (is_array($PathComponents) )
		{
			$partialPath =  '/' .join('/', $PathComponents );
			$this->RequestedPath .= $partialPath;
			$this->CurrentDirPath .= $partialPath;
			$this->PhysicalPath .= $partialPath;
			$this->CurrDirName = array_pop($PathComponents);
			$this->PrevPath .= '/' . join('/', $PathComponents );
		}
		else
		{
			$this->isTopLevel = true;
			$this->CurrDirName = $rootName;
		}
		
		$this->PathComponents = $PathComponents;
	}

}

class Items
{
	var $List;
	var $CurrentItem;
	var $PrevItems;
	function Items(&$aInfo)
	{
		$this->List = array();
		$file_path = $aInfo->PhysicalPath; 
		$this->CurrentItem = new ItemInfo($file_path, $aInfo->CurrDirName, $aInfo );
		$this->PrevItems= array();
		if (is_array( $aInfo->PathComponents ) )
		{
			$partial_path = $aInfo->RootPhysicalPath;
			for ($i = 0; $i  < count( $aInfo->PathComponents ) ; ++$i )
			{	
				$partial_path .= '/' . $aInfo->PathComponents[$i];
				$this->PrevItems[]  =  new ItemInfo($partial_path, $aInfo->PathComponents[$i] , $aInfo);
			}

		}
		$this->PrevItems[] = $this->CurrentItem;
//		echo $file_path;
		if ($dir = opendir($file_path)) 
		{
			while ($file = readdir($dir)) 
			{
				if ( filetype($file_path.'/'.$file) == 'dir' && $file != '.' && $file != '..' )
    				{
    					$sub_path = $file_path.'/'.$file;
					$this->List[] = new ItemInfo($sub_path, $file , $aInfo);
				}
			}
			closedir($dir);
		}
		

	}
}

class ItemInfo
{
	var $Name;
	var $Type;
	var $FriendlyName;
	var $Decription;
	var $DecriptionType;
	var $LinkUrl;
	var $StartPage;
	var $OtherDoc;
	
	function ItemInfo($path, $name ,$aFSInfo)
	{
		$this->Name = $name;
		$this->Decription = '...';
		$this->DecriptionType = 'text';

		if ( file_exists ($path . '/article.info' ) )
		{
			$this->Type = 'article';
			$this->parseInfo($path . '/article.info' );
			//$this->LinkUrl = $aFSInfo->CurrentDirPath . '/'. $this->Name . '/'. $this->StartPage;
			$this->LinkUrl =  htmlspecialchars( $aFSInfo->RequestedPath . 
				'/'. $this->Name . '?view='. $this->StartPage) ;
			if ( $this->OtherDoc != '' ) 
				$this->OtherDocUrl = htmlspecialchars( $aFSInfo->CurrentDirPath . '/'. $this->Name . '/'. $this->OtherDoc) ;
		}
		else
		{
			$this->Type = 'dir';
			if ( file_exists ($path . '/dir.info' ) )
			{
				$this->parseInfo($path . '/dir.info' );	

			}
			$this->LinkUrl = $aFSInfo->RequestedPath  . '/'. $this->Name;
		}
		if ($this->FriendlyName == '' ) 
		{
			$this->FriendlyName = $this->Name;
		}
		$this->LinkText = $this->FriendlyName; 
	}

	function parseInfo($infoFilename)
	{
		$lines = file($infoFilename);

		foreach ($lines as $val)
		{
			if (preg_match('/^!/', $val ) )
			{
				$this->FriendlyName = substr($val, 1);
			} 
			else if (preg_match('/^#/', $val ) )
			{
				$this->DecriptionType = substr($val, 1);
			}
			else if ( preg_match('/^@/', $val ) )
			{
				$this->StartPage = trim( substr($val, 1) );
				$this->StartPageExtension= $this->getExtension( $val);
			}
			else if ( preg_match('/^%/', $val) )
			{
				$this->OtherDoc = trim( substr($val, 1) );
				$this->OtherDocExtension = trim( $this->getExtension( $val) );
			}
			else 
				$this->Description .= $val;
		}
		if ($this->StartPageExtension =='' ) $this->StartPageExtension = 'html';
	}
	function getExtension($val)
	{
		if ( preg_match('/\.(.*)$/', $val, $match) )
			return $match[1];
		else
			return '';
	}
}

?>