/* $Id$ */

#include<time.h>
#include<math.h>

#include<glib.h>
#include<gtk/gtk.h>
#include<glade/glade.h>

#include<libxml/parser.h>
#include<libxml/xpath.h>
#include<libxml/uri.h>

#include"dh-util.h"
#include"dh-update.h"

#define BYTES_OVER_HTTP 4096
#define EXT_HTML ".htm"

typedef struct _DhBook DhBook;
typedef struct _Chapter Chapter;

struct _DhBook {
    time_t mtime;
    gchar *uri;
    gchar *title;
};

struct _Chapter {
    gchar *file; 
    gchar *uri; 
};

static void update_get_book_list(xmlDocPtr doc, GSList **list);
static void update_dhbook_free(gpointer data,gpointer user_data);
static void update_renew(void);
static gboolean update_progress(gpointer data);
static gchar *update_get_strip_uri(const gchar *uri,gchar *anchor);
void update_update_book(DhBook *book);
static void update_write_file_from_uri(const gchar *filename,const gchar *uri);
static void update_gnome_vfs_perror(GnomeVFSResult result,const gchar *uri);
void update_chapter_free(gpointer chapter);
    

static gboolean on_dialog_update_delete_event(GtkWidget *window,
                                              GdkEvent *event,
                                              gpointer user_data);
static void on_btn_cancle_clicked(GtkWidget *button,gpointer user_data);
static void on_btn_done_clicked(GtkWidget *button,gpointer user_data);

/* global variables */
DhUpdate *dh_update;

static gboolean on_dialog_update_delete_event(GtkWidget *window,
                                            GdkEvent *event,
                                            gpointer user_data)
{
    gtk_widget_hide(window);

    return TRUE;
}
    
static void on_btn_cancle_clicked(GtkWidget *button,gpointer user_data)
{
    gtk_widget_hide(dh_update->window);
}

static void on_btn_done_clicked(GtkWidget *button,gpointer user_data)
{
    gtk_widget_hide(dh_update->window);
}
                                    
void dh_update_init(DhBase *base)
{
    GladeXML *gui;
    gchar *dir;


    /* make the local directory */
    dir = g_build_path("/",g_get_home_dir(), ".dhon",NULL);
    dh_mkdir(dir);
    g_free(dir);
    
    dir = g_build_path("/",g_get_home_dir(), ".dhon","books",NULL);
    dh_mkdir(dir);
    g_free(dir);
            
    dh_update = g_new0(DhUpdate,1);
    dh_update->base = base;

    /* initiate window */
    gui = glade_xml_new(GLADEDIR "/dhon-gtk.glade","dialog_update",NULL);
    dh_update->window = glade_xml_get_widget(gui,"dialog_update");
    dh_update->pb_update = glade_xml_get_widget(gui,"pb_update");
    dh_update->pb_download = glade_xml_get_widget(gui,"pb_download");
    dh_update->btn_done = glade_xml_get_widget(gui,"btn_done");
    dh_update->label_status = glade_xml_get_widget(gui,"label_status");

    /* connect all of the signals */
    glade_xml_signal_connect(gui,"on_dialog_update_delete_event",
            G_CALLBACK(on_dialog_update_delete_event));
    glade_xml_signal_connect_data(gui,"on_btn_done_clicked",
            G_CALLBACK(on_btn_done_clicked),dh_update);
    glade_xml_signal_connect_data(gui,"on_btn_cancle_clicked",
            G_CALLBACK(on_btn_cancle_clicked),dh_update);

    return ;
}


static void update_get_book_list(xmlDocPtr doc,GSList **list)
{
    xmlXPathContextPtr xpathCtx;
    xmlXPathObjectPtr xpathObj;
    xmlNodeSetPtr nodes;
    xmlNodePtr cur;

    DhBook *book;

    int i;
    int size;

    xpathCtx = xmlXPathNewContext(doc);
    if(xpathCtx == NULL)
    {
        g_print("unable to create new XPath context\n");
        return;
    }

    xpathObj = xmlXPathEvalExpression("//book",xpathCtx);
    if(xpathObj == NULL)
    {
        g_print("unable to evaluate xpath expression\n");
        return ;
    }

    size = xpathObj->nodesetval->nodeNr;
    nodes = xpathObj->nodesetval;

    for(i=0;i < size;i++)
    {
        cur = nodes->nodeTab[i];

        book = g_new0(DhBook,1);
        book->title = xmlGetProp(cur,"title");
        book->uri = xmlGetProp(cur,"uri");
#if 0
        g_print("title: %s\turi: %s\n",book->title,book->uri);
#endif

        *list = g_slist_append(*list,book);
    }

    xmlXPathFreeObject(xpathObj);
    xmlXPathFreeContext(xpathCtx);
}


static void update_dhbook_free(gpointer data,gpointer user_data)
{
    /* all free */
    xmlFree(((DhBook*)data)->title);
    g_free(((DhBook*)data)->uri);
}


static gboolean update_progress(gpointer data)
{
    if(dh_update->val_update <= 1.0)
        gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_update),
                dh_update->val_update);

    if(dh_update->val_download <= 1.0)
        gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_download),
                dh_update->val_download);
        
    if(dh_update->val_update == 1.0 && dh_update->val_download == 1.0)
        return TRUE;
    else 
        return FALSE;
}


static void update_renew(void)
{
    /* set window */
    gtk_widget_set_sensitive(GTK_WIDGET(dh_update->btn_done),FALSE);
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_update),0.0);
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_download),0.0);
    dh_update->val_update = 0.0;
    dh_update->val_download = 0.0;
    gtk_label_set_text(GTK_LABEL(dh_update->label_status),""); 
}


void dh_update_do(void)
{
    DhBase *base;
    DhBasePriv *priv;

    xmlDocPtr doc;

    GSList *cur;
    GSList *booklist=NULL;
    DhLibrary *libelmt;
    DhBook *book;

    gdouble step_update;
    gdouble step_download;

    base = dh_update->base;
    priv = base->priv;
    
    /* If list is empty,just return */
    if(g_slist_length(priv->library) == 0)
        return;

    /* Renew the update window */
    update_renew();
    gtk_widget_show_all(dh_update->window);
    g_timeout_add(50,(GSourceFunc)update_progress,NULL);
    while (gtk_events_pending()) { gtk_main_iteration(); }

    /* There is a loop for updating all booklist from library */
    step_update = 1.0/g_slist_length(priv->library);
    cur = g_slist_nth(priv->library,0);

    while(cur != NULL)
    {
        libelmt = (DhLibrary*)cur->data;

        doc = xmlParseFile(libelmt->uri);

        /* get booklist */
        update_get_book_list(doc,&booklist);
 
        xmlFreeDoc(doc);
        xmlCleanupParser();

        cur = g_slist_next(cur);

        dh_update->val_update += step_update;
        gtk_progress_bar_set_text(GTK_PROGRESS_BAR(dh_update->pb_update),
                libelmt->name);
        while (gtk_events_pending()) { gtk_main_iteration(); }
    }
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_update),
                1.0);
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(dh_update->pb_update),
                        "Update completed");

    cur = g_slist_nth(booklist,0);
    while(cur != NULL)
    {
        book = (DhBook*)cur->data;
        
        update_update_book(book);

        cur = g_slist_next(cur);
        dh_update->val_download += step_download;
        gtk_progress_bar_set_text(GTK_PROGRESS_BAR(dh_update->pb_download),
                book->title);
        while (gtk_events_pending()) { gtk_main_iteration(); }
    }
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_download),1.0);
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(dh_update->pb_download),
                                "Download completed");
    gtk_widget_set_sensitive(GTK_WIDGET(dh_update->btn_done),TRUE);
    /* print "reboot" message */
    gtk_label_set_text(GTK_LABEL(dh_update->label_status),"The updated books will be found after you restart this program"); 

    /* end of function - must all free */
    /* remove booklist */
    g_slist_foreach(booklist,update_dhbook_free,NULL);
    g_slist_remove_all(booklist,NULL);
}

void update_update_book(DhBook *book)
{
    xmlDocPtr doc;
    xmlXPathContextPtr xpathCtx;
    xmlXPathObjectPtr xpathObj;
    xmlXPathObjectPtr xpathObj_b;
    xmlNodeSetPtr nodes;
    xmlNodeSetPtr nodes_b;
    xmlNodePtr cur;

    GHashTable *table;

    gchar *raw_uri;
    gchar anchor[128];
    gchar *chap_uri;
    gchar *book_dir;
    gchar *file;
    Chapter *chap;
    gchar *auri;

    int i;
    int size;

    /* make a directory of book */
    book_dir = g_build_path("/",g_get_home_dir(),".dhon","books",book->title,NULL);
    dh_mkdir(book_dir);

    doc = xmlParseFile(book->uri);
    if(doc == NULL)
    {
        g_print("parse error: %s\n",book->uri);
        return;
    }

    xpathCtx = xmlXPathNewContext(doc);
    if(xpathCtx == NULL)
    {
        g_print("unable to create new XPath context\n");
        return;
    }

    xpathObj = xmlXPathEvalExpression("//sub",xpathCtx);
    if(xpathObj == NULL)
    {
        g_print("unable to evaluate xpath expression\n");
        return ;
    }

    table = g_hash_table_new_full(g_str_hash,g_str_equal,
            NULL,update_chapter_free);
    
    xpathObj_b = xmlXPathEvalExpression("/book",xpathCtx);
    nodes_b = xpathObj_b->nodesetval;
    cur = nodes_b->nodeTab[0];

    /* raw_uri, chap->uri,chap->file,chap will be freed when g_hash_table 
     * is freed */
    raw_uri = xmlGetProp(cur,"link"); 
    chap = g_new(Chapter,1);
    chap->uri = raw_uri;
    chap->file = g_strdup_printf("%s_0.htm",book->title);
    g_hash_table_insert(table,raw_uri,chap);
    xmlSetProp(cur,"link",chap->file);

    file = g_build_filename(book_dir,chap->file,NULL);
    update_write_file_from_uri(file,raw_uri);
    g_free(file);

    size = xpathObj->nodesetval->nodeNr;
    nodes = xpathObj->nodesetval;
    for(i=0;i < size;i++)
    {
        cur = nodes->nodeTab[i];
        raw_uri = xmlGetProp(cur,"link");
        chap_uri = update_get_strip_uri(raw_uri,anchor);
        g_free(raw_uri);
       if((chap = g_hash_table_lookup(table,chap_uri)) == NULL)
        {
            chap = g_new(Chapter,1);
            chap->uri = chap_uri; /*will be freed when the hash table is destroid*/
            chap->file = g_strdup_printf("%s_%d.htm",book->title,(i+1));
            g_hash_table_insert(table,chap->uri,chap);

            auri = g_strdup_printf("%s#%s",chap->file,anchor);
            xmlSetProp(cur,"link",auri);
            g_free(auri);
            
            file = g_build_filename(book_dir,chap->file,NULL);
            update_write_file_from_uri(file,chap->uri);
            g_free(file);
        }else {
            g_free(chap_uri);

            auri = g_strdup_printf("%s#%s",chap->file,anchor);
            xmlSetProp(cur,"link",auri);
            g_free(auri);
        }
    }

    file = g_strdup_printf("%s/%s.devhelp",book_dir,book->title);
    xmlSaveFile(file,doc);
    g_free(file);

    g_hash_table_destroy(table);
    xmlXPathFreeObject(xpathObj);
    xmlXPathFreeContext(xpathCtx);
}

void update_chapter_free(gpointer chapter)
{
    g_free(((Chapter*)chapter)->file);
    g_free(((Chapter*)chapter)->uri);
}


static gchar *update_get_strip_uri(const gchar *uri,gchar *anchor)
{
    gchar **result;
    gchar *striped;

    result = g_strsplit(uri,"#",1024);

    striped = g_strdup(result[0]);
    g_strlcpy(anchor,result[1],128);

    g_strfreev(result);

    return striped;
}


static void update_write_file_from_uri(const gchar *filename,const gchar *uri)
{
    GnomeVFSHandle *hd_read, *hd_write;
    GnomeVFSFileSize sz_read,sz_write;
    GnomeVFSResult result;
    guchar buf[4096];


    result = gnome_vfs_open(&hd_read,uri,GNOME_VFS_OPEN_READ);
    if(result != GNOME_VFS_OK)
    {
        g_print("%s open error\n",uri);
        return;
    }
    result = gnome_vfs_create(&hd_write,filename,GNOME_VFS_OPEN_WRITE,FALSE,
            0644);
    if(result != GNOME_VFS_OK)
    {
        g_print("%s create error\n",filename);
        return ;
    }

    result = gnome_vfs_read(hd_read,buf,BYTES_OVER_HTTP,&sz_read);
    while(result == GNOME_VFS_OK)
    {
        result = gnome_vfs_write(hd_write,buf,sz_read,&sz_write);
        if(result != GNOME_VFS_OK)
        {
            update_gnome_vfs_perror(result,filename);
            break;
        }
        result = gnome_vfs_read(hd_read,buf,BYTES_OVER_HTTP,&sz_read);
    }

    gnome_vfs_close(hd_read);
    gnome_vfs_close(hd_write);
}

static void update_gnome_vfs_perror(GnomeVFSResult result,
        const gchar *uri)
{
    const gchar *err;

    err = gnome_vfs_result_to_string(result);
    g_print("Error %s occured opening location %s\n",err,uri);

    return;
}
