/* $Id$ */

#include <config.h>

#include <glade/glade.h>
#include <gtk/gtk.h>

#include <string.h>


#include "dh-util.h" 
#include "dh-gecko-utils.h"
#include "dh-libmgr.h"
#include "dh-base.h"
#include "dh-window.h"

typedef struct _DHLibMgr{
	GtkWidget *dialog;
	GtkWidget *listview;
	GtkWidget *entry_name;
	GtkWidget *entry_uri;
	GtkWidget *btn_add;
	GtkWidget *btn_del;
	GtkWidget *btn_ok;
	GtkWidget *btn_cancle;
	DhBase *base;
    GtkTreeSelection *select;

} DhLibMgr;

#define DH_LIBMGR(x) ((DhLibMgr *) x)

enum
{
	ACTIVATION_COLUMN,
	SITENAME_COLUMN,
	URL_COLUMN,
	N_COLUMN
};

/* event handler */
static void on_btn_cancle_clicked (GtkButton *button, gpointer user_data);
static void on_btn_ok_clicked (GtkButton *button,gpointer user_data);
static void on_btn_add_clicked (GtkButton *button,gpointer user_data);
static void on_btn_del_clicked (GtkButton *button,gpointer user_data);
static void on_activation_toggled (GtkCellRendererToggle *renderer,
				gchar *path,
				gpointer user_data);

static void dh_libmgr_listview_init(void);

static void libmgr_load(DhLibMgr *libmgr);
static void libmgr_save(DhLibMgr *libmgr);
 
DhLibMgr *libmgr;

static void
on_btn_cancle_clicked (GtkButton *button, gpointer user_data)
{
	DhLibMgr *libmgr;

	libmgr = DH_LIBMGR (user_data);

	gtk_widget_hide (GTK_WIDGET (libmgr->dialog));

    libmgr_load(libmgr);
}

static void
on_btn_ok_clicked (GtkButton *button, gpointer user_data)
{
	DhLibMgr *libmgr;

	libmgr = DH_LIBMGR (user_data);

	gtk_widget_hide (GTK_WIDGET (libmgr->dialog));

    libmgr_save(libmgr);
}

static void on_btn_add_clicked (GtkButton *button,gpointer user_data)
{
	DhLibMgr *libmgr;
	const gchar *uri,*name;
	GtkTreeIter iter;
	GtkListStore *store;
	DhBase *base;
	DhBasePriv *priv;

	libmgr = DH_LIBMGR (user_data);
	
	name = gtk_entry_get_text(GTK_ENTRY(libmgr->entry_name));
	uri = gtk_entry_get_text(GTK_ENTRY(libmgr->entry_uri));

	base = libmgr->base;
	priv = base->priv;

	store = GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(libmgr->listview)));
	gtk_list_store_append(store,&iter);

	gtk_list_store_set(store,&iter,
			ACTIVATION_COLUMN,TRUE,
			SITENAME_COLUMN,name,
			URL_COLUMN,uri,
			-1);

    /* clean entrys */
    gtk_entry_set_text(GTK_ENTRY(libmgr->entry_name),"");
    gtk_entry_set_text(GTK_ENTRY(libmgr->entry_uri),"");
    /* set focus */
    gtk_widget_grab_focus(GTK_WIDGET(libmgr->entry_name));

}

static void on_btn_del_clicked (GtkButton *button,gpointer data)
{
    GtkTreeModel *store;
    GtkTreeIter iter;
    GtkTreeSelection *selection;
    
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(libmgr->listview));
    
    gtk_tree_selection_get_selected(selection,&store,&iter);
    
    gtk_list_store_remove(GTK_LIST_STORE(store),&iter);
}

static void on_activation_toggled (GtkCellRendererToggle *renderer,
				gchar *path,
				gpointer user_data)
{
/*	DhBase *base;
	DhBasePriv *priv;*/
	gboolean activity;
	GtkTreeIter iter;
/*	GValue val;*/
	GtkListStore *store = GTK_LIST_STORE(user_data);
/*	GSList *library;
	DhLibrary *libelmt;
    DhLibrary libcomp;
	gchar *name;*/

/*    base = libmgr->base;
	priv = base->priv;*/

	activity = gtk_cell_renderer_toggle_get_active(renderer);
/*	if(activity == TRUE)
        priv->count_library--;
    else
        priv->count_library++;*/

	gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(store), &iter, path);
	gtk_list_store_set(store,&iter,
			ACTIVATION_COLUMN,!activity,
			-1);

/*	memset(&val,0,sizeof(GValue));
	gtk_tree_model_get_value(GTK_TREE_MODEL(store),&iter,SITENAME_COLUMN,&val);
	name = (gchar*)(g_value_get_string(&val));

    libcomp.name = name;
    
	library = g_slist_find_custom(priv->library,&libcomp,dh_library_comp_func);

    if(library == NULL)
        g_print("null\n");

	libelmt = (DhLibrary*)library->data;
    libelmt->activation = !activity;*/
}

void
dh_libmgr_init (DhBase *base)
{
	GladeXML *gui;
/*	GtkWidget *widget;*/

/*	gconf_client_libmgr = gconf_client_get_default ();
	gconf_client_add_dir (gconf_client_libmgr,
			      GCONF_PATH,
			      GCONF_CLIENT_PRELOAD_ONELEVEL,
			      NULL);*/
	libmgr = g_new0 (DhLibMgr, 1);
    libmgr->select = NULL;
	libmgr->base = base;

	gui = dh_glade_get_file(GLADEDIR "/dhon-gtk.glade",
				"dialog_libmgr",
				NULL,
				"dialog_libmgr", &libmgr->dialog,
				"listview_libmgr",&libmgr->listview,
				"entry_name",&libmgr->entry_name,
				"entry_uri",&libmgr->entry_uri,
				"btn_add",&libmgr->btn_add,
				"btn_del",&libmgr->btn_del,
				"btn_ok",&libmgr->btn_ok,
				"btn_cancle",&libmgr->btn_cancle,
				NULL);

	dh_glade_connect(gui,
			libmgr,
			"btn_ok","clicked",on_btn_ok_clicked,
			"btn_cancle","clicked",on_btn_cancle_clicked,
			"btn_add","clicked",on_btn_add_clicked,
			"btn_del","clicked",on_btn_del_clicked,
			NULL);

	dh_libmgr_listview_init();
	
	g_object_unref (gui);
}

void dh_libmgr_listview_init()
{
	GtkWidget *tree;
	GtkListStore *store;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

	tree = libmgr->listview;

	store = gtk_list_store_new(N_COLUMN,
			G_TYPE_BOOLEAN, /* activation */
			G_TYPE_STRING, /* site name */
			G_TYPE_STRING); /* uri */

	gtk_tree_view_set_model(GTK_TREE_VIEW(tree),GTK_TREE_MODEL(store));
	g_object_unref(G_OBJECT(store));


	renderer = gtk_cell_renderer_toggle_new();
	/* signal connect */
	g_signal_connect(G_OBJECT(renderer),"toggled",
			G_CALLBACK(on_activation_toggled),store);
	column = gtk_tree_view_column_new_with_attributes(
			"Activation",renderer,
			"active",ACTIVATION_COLUMN
			,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tree),column);

	
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(
			"Site name",renderer,
			"text",SITENAME_COLUMN,
			NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tree),column);

	
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(
			"URL",renderer,
			"text",URL_COLUMN,
			NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tree),column);

    /* connect some signals. */
    libmgr->select = gtk_tree_view_get_selection(GTK_TREE_VIEW(tree));
    gtk_tree_selection_set_mode(GTK_TREE_SELECTION(libmgr->select),
                            GTK_SELECTION_SINGLE);
}

void
dh_libmgr_show_dialog (GtkWindow *parent)
{
    libmgr_load(libmgr);
	gtk_window_set_transient_for (GTK_WINDOW (libmgr->dialog), parent); 
	gtk_widget_show_all (libmgr->dialog);
}
static void libmgr_load(DhLibMgr *libmgr)
{
    DhBase *base;
    DhBasePriv *priv;
    GtkListStore *store;
    GtkTreeIter iter;
    DhLibrary *libelmt;
    GSList *list;

    base = libmgr->base;
    priv = base->priv;
    
    store = GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(libmgr->listview)));
    gtk_list_store_clear(store);

   if(g_slist_length(priv->library) == 0)
        return;
    
    list = g_slist_nth(priv->library,0);

    while(list != NULL)
    {
        libelmt = (DhLibrary*)list->data;

        gtk_list_store_append(store,&iter);
        gtk_list_store_set(store,&iter,
			ACTIVATION_COLUMN,libelmt->activation,
			SITENAME_COLUMN,libelmt->name,
			URL_COLUMN,libelmt->uri,
			-1);

        list = g_slist_next(list);
    }
}

static void libmgr_save(DhLibMgr *libmgr)
{
    DhBase *base;
    DhBasePriv *priv;
    GtkListStore *store;
    GtkTreeIter iter;
    DhLibrary *libelmt;
    gboolean valid;
    DhWindow *window;
    gboolean update_flag = FALSE;
    
    GValue activation;
    GValue name;
    GValue uri;

    base = libmgr->base;
    priv = base->priv;

    /* all remove */
    g_slist_foreach(priv->library,(GFunc)dh_library_free,NULL);
    g_slist_free(priv->library);
    priv->library = NULL;

    store = GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(libmgr->listview)));

    valid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(store),&iter);

    while(valid)
    {
    
        libelmt = g_new0(DhLibrary,1);

        memset(&activation,0,sizeof(GValue));
        memset(&name,0,sizeof(GValue));
        memset(&uri,0,sizeof(GValue));
    
        gtk_tree_model_get_value(GTK_TREE_MODEL(store),&iter,
                ACTIVATION_COLUMN,&activation);
        gtk_tree_model_get_value(GTK_TREE_MODEL(store),&iter,
                SITENAME_COLUMN,&name);
        gtk_tree_model_get_value(GTK_TREE_MODEL(store),&iter,
                URL_COLUMN,&uri);

        libelmt->activation = g_value_get_boolean(&activation);
        libelmt->name = g_strdup(g_value_get_string(&name));
        libelmt->uri = g_strdup(g_value_get_string(&uri));

        if(libelmt->activation == TRUE)
            update_flag = TRUE;

        priv->library = g_slist_append(priv->library,libelmt);

        valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(store),&iter);
    }

    window = DH_WINDOW(g_slist_nth_data(priv->windows,0));
    g_return_if_fail(DH_IS_WINDOW(window));
    
    if(update_flag == TRUE)
        dh_window_set_sensible(window,"Refresh",TRUE);
    else
        dh_window_set_sensible(window,"Refresh",FALSE);

    dh_base_save_conf(priv->library);
}
