/* $Id$ */

#include<time.h>
#include<math.h>

#include<glib.h>
#include<gtk/gtk.h>
#include<glade/glade.h>

#include<libxml/parser.h>
#include<libxml/HTMLparser.h>
#include<libxml/uri.h>

#include"dh-util.h"
#include"dh-update.h"


#define QUERY_LIB "?action=devhelp&mode=library"
#define QUERY_BOOK "?action=devhelp&mode=book"
#define QUERY_BOOK_CACHE "?action=devhelp&mode=book&cache=true"
#define QUERY_SHOW "?action=devhelp&mode=show"
#define QUERY_CACHE "?action=devhelp&mode=cache"

#define NODE_LIBRARY "library"
#define NODE_CATEGORY "category"
#define NODE_BOOK "book"

#define BYTES_OVER_HTTP 4096
#define EXT_HTML ".htm"

typedef struct _DhBook DhBook;

struct _DhBook {
    time_t mtime;
    gchar *uri;
    gchar *title;
};

static void update_get_book_list(const gchar *base_uri,
                                GSList **list,
                                xmlNodePtr node);
static void update_dhbook_free(gpointer data,gpointer user_data);
static gchar *dh_escape_uri(const gchar *uri);
static void update_renew(void);
static gboolean update_progress(gpointer data);
static gchar *update_get_strip_uri(const gchar *uri);
static void update_get_html(xmlDocPtr doc,const gchar *book_dir);
static void update_get_html_recur(xmlNodePtr node,const gchar *book_dir);
static void update_save_html_from_uri(const gchar *uri,const gchar *filename);
static void update_gnome_vfs_perror(GnomeVFSResult result,const gchar *uri);
    

static gboolean on_dialog_update_delete_event(GtkWidget *window,
                                              GdkEvent *event,
                                              gpointer user_data);
static void on_btn_cancle_clicked(GtkWidget *button,gpointer user_data);
static void on_btn_done_clicked(GtkWidget *button,gpointer user_data);

/* global variables */
DhUpdate *dh_update;

static gboolean on_dialog_update_delete_event(GtkWidget *window,
                                            GdkEvent *event,
                                            gpointer user_data)
{
    gtk_widget_hide(window);

    return TRUE;
}
    
static void on_btn_cancle_clicked(GtkWidget *button,gpointer user_data)
{
    gtk_widget_hide(dh_update->window);
}

static void on_btn_done_clicked(GtkWidget *button,gpointer user_data)
{
    gtk_widget_hide(dh_update->window);
}
                                    
void dh_update_init(DhBase *base)
{
    GladeXML *gui;
    gchar *dir;


    /* make the local directory */
    dir = g_build_path("/",g_get_home_dir(), ".devhelp",NULL);
    dh_mkdir(dir);
    g_free(dir);
    
    dir = g_build_path("/",g_get_home_dir(), ".devhelp","books",NULL);
    dh_mkdir(dir);
    g_free(dir);
            
    dh_update = g_new0(DhUpdate,1);
    dh_update->base = base;

    /* initiate window */
    gui = glade_xml_new(GLADEDIR "/devhelp.glade","dialog_update",NULL);
    dh_update->window = glade_xml_get_widget(gui,"dialog_update");
    dh_update->pb_update = glade_xml_get_widget(gui,"pb_update");
    dh_update->pb_download = glade_xml_get_widget(gui,"pb_download");
    dh_update->btn_done = glade_xml_get_widget(gui,"btn_done");
    dh_update->label_status = glade_xml_get_widget(gui,"label_status");

    /* connect all of the signals */
    glade_xml_signal_connect(gui,"on_dialog_update_delete_event",
            G_CALLBACK(on_dialog_update_delete_event));
    glade_xml_signal_connect_data(gui,"on_btn_done_clicked",
            G_CALLBACK(on_btn_done_clicked),dh_update);
    glade_xml_signal_connect_data(gui,"on_btn_cancle_clicked",
            G_CALLBACK(on_btn_cancle_clicked),dh_update);

    return ;
}

/*void dh_update_free(DhUpdate *dh_update)
{

}*/

/* FIXME - make here much more lucid
   because the relation of function and free function is inferior */
static void update_get_book_list(const gchar *base_uri,
                                GSList **list,
                                xmlNodePtr node)
{
    DhBook *book;
    xmlNodePtr cur = NULL;

    cur = node;

    while(cur != NULL)    
    {
        if(xmlStrcmp(cur->name,NODE_LIBRARY) == 0)
        {
            cur = cur->children;

        } else if(xmlStrcmp(cur->name,NODE_CATEGORY) == 0) {
            
            update_get_book_list(base_uri,list,cur->children);

        } else if(xmlStrcmp(cur->name,NODE_BOOK) == 0)
        {
            book = g_new0(DhBook,1);

            /* get a book name */
            book->title = xmlGetProp(cur,"title");

            /* concat both uri and bookname */
            book->uri = g_strconcat(base_uri,book->title,NULL);

            /* append a book to list */
            *list = g_slist_append(*list,book);
        }

        cur = cur->next; 
    }

    return;
}

static void update_dhbook_free(gpointer data,gpointer user_data)
{
    /* all free */
    xmlFree(((DhBook*)data)->title);
    g_free(((DhBook*)data)->uri);
}

static gboolean update_progress(gpointer data)
{
    if(dh_update->val_update <= 1.0)
        gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_update),
                dh_update->val_update);

    if(dh_update->val_download <= 1.0)
        gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_download),
                dh_update->val_download);
        
    if(dh_update->val_update == 1.0 && dh_update->val_download == 1.0)
        return TRUE;
    else 
        return FALSE;
}

static void update_renew(void)
{
    /* set window */
    gtk_widget_set_sensitive(GTK_WIDGET(dh_update->btn_done),FALSE);
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_update),0.0);
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_download),0.0);
    dh_update->val_update = 0.0;
    dh_update->val_download = 0.0;
}

void dh_update_do(void)
{
    DhBase *base;
    DhBasePriv *priv;

    GSList *list = NULL;
    GSList *booklist = NULL;
    
    xmlDocPtr doc = NULL;
    xmlDocPtr cache_doc = NULL;
    xmlNodePtr root_element = NULL;
    
    gchar *base_uri;

    DhLibrary *libelmt;
    DhBook *book;
    gchar *uri,*con_uri;
    gchar *cache_uri,*cache_con_uri;
    gchar *local_dir;
    gchar *book_dir;
    gchar *fullname;
    gchar *filename;
    gdouble step_update;
    gdouble step_download;

    base = dh_update->base;
    priv = base->priv;

    /* if list is empty. */
    if(g_slist_length(priv->library) == 0)
        return;

    /* renew the update window */
    update_renew();

    gtk_widget_show_all(dh_update->window);
    g_timeout_add(50,(GSourceFunc)update_progress,NULL);
    while (gtk_events_pending()) { gtk_main_iteration(); }

    /* There is a loop for updating all booklist from library */
    step_update = 1.0/g_slist_length(priv->library);
    list = g_slist_nth(priv->library,0);
    while(list != NULL)
    {
        libelmt = (DhLibrary*)list->data;

        /* must be freed */
        con_uri = g_strconcat(libelmt->uri,QUERY_LIB,NULL);
        /* must be freed */
        uri = dh_escape_uri(con_uri);

        /* must be freed */
        doc = xmlParseFile(uri);
        root_element = xmlDocGetRootElement(doc);

        /* get base_uri */
        /* must be free */
        base_uri = xmlGetProp(root_element,"uri"); 

        /* get booklist */
        update_get_book_list(base_uri,&booklist,root_element);
    
        g_free(con_uri);
        xmlFree(base_uri);
        g_free(uri); 
        xmlFreeDoc(doc);
        xmlCleanupParser();

        list = g_slist_next(list);
        dh_update->val_update += step_update;
        gtk_progress_bar_set_text(GTK_PROGRESS_BAR(dh_update->pb_update),
                libelmt->name);
        while (gtk_events_pending()) { gtk_main_iteration(); }
    }
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_update),1.0);
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(dh_update->pb_update),
            "Update completed");

    /* There is a loop for downloading all books from a wiki page */
    local_dir = g_build_path("/",g_get_home_dir(),".devhelp","books",NULL);
    step_download = 1.0/g_slist_length(booklist);
    list = g_slist_nth(booklist,0);
    while(list != NULL)
    {
        book = (DhBook*)list->data;

        book_dir = g_build_path("/",local_dir,book->title,NULL);
        dh_mkdir(book_dir);
        con_uri = g_strconcat(book->uri,QUERY_BOOK,NULL);
        uri = dh_escape_uri(con_uri);
        cache_con_uri = g_strconcat(book->uri,QUERY_BOOK_CACHE,NULL);
        cache_uri = dh_escape_uri(cache_con_uri);
                
        /* get a book file */
        doc = xmlParseFile(uri);
        if(doc != NULL) /* if doc is valid */
        {
            /* get a fullpath filename to save */
            filename = dh_get_devhelp_file(book->title);
            fullname = g_build_filename(book_dir,filename);
            cache_doc = xmlParseFile(cache_uri);
            xmlSaveFile(fullname,cache_doc);
/*            xmlSaveFile(fullname,doc);*/

            update_get_html(doc,book_dir);

            //        html_doc = htmlDocPtr(

            /* free all*/
            g_free(filename);
            g_free(fullname);
            xmlFreeDoc(doc);
            xmlFreeDoc(cache_doc);
            xmlCleanupParser();
        }
        g_free(book_dir);
        g_free(con_uri);
        g_free(uri);
        g_free(cache_con_uri);
        g_free(cache_uri);
        
        list = g_slist_next(list);
        dh_update->val_download += step_download;
        gtk_progress_bar_set_text(GTK_PROGRESS_BAR(dh_update->pb_download),
                book->title);
        while (gtk_events_pending()) { gtk_main_iteration(); }
    }
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(dh_update->pb_download),1.0);
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(dh_update->pb_download),
                "Download completed");
    gtk_widget_set_sensitive(GTK_WIDGET(dh_update->btn_done),TRUE);

    /* print "reboot" message */
    gtk_label_set_text(GTK_LABEL(dh_update->label_status),"The updated books will be found after you restart this program");

    g_free(local_dir);

    /* remove booklist */
    g_slist_foreach(booklist,update_dhbook_free,NULL);
    g_slist_remove_all(booklist,NULL);
    
    /* hide window */
    /* gtk_widget_hide(dh_update->window);*/

    return;
}

/*static void update_get_html()
{

}*/

static gchar *update_get_strip_uri(const gchar *uri)
{
    gchar **result;
    gchar *striped;

    result = g_strsplit(uri,"#",1024);

    striped = g_strdup(result[0]);

    g_strfreev(result);

    return striped;
}

static void update_get_html(xmlDocPtr doc,const gchar *book_dir)
{
    xmlNodePtr root_node;
    xmlNodePtr cur;

    root_node = xmlDocGetRootElement(doc);

    cur = root_node->children;

    while(cur != NULL)
    {
        if( xmlStrcmp(cur->name,"chapters") == 0)
        {
            if(cur->children != NULL);
                update_get_html_recur(cur->children,book_dir);
            return ;
        }
        
        cur = cur->next;
    }

    return ;
}

static void update_save_html_from_uri(const gchar *uri,const gchar *filename)
{
    GnomeVFSHandle *hd_read, *hd_write;
    GnomeVFSFileSize sz_read,sz_write;
    GnomeVFSResult result;
    guchar buf[4096];


    result = gnome_vfs_open(&hd_read,uri,GNOME_VFS_OPEN_READ);
    if(result != GNOME_VFS_OK)
    {
        g_print("%s open error\n",uri);
        return;
    }
    result = gnome_vfs_create(&hd_write,filename,GNOME_VFS_OPEN_WRITE,FALSE,
            0644);
    if(result != GNOME_VFS_OK)
    {
        g_print("%s create error\n",filename);
        return ;
    }

    result = gnome_vfs_read(hd_read,buf,BYTES_OVER_HTTP,&sz_read);
    while(result == GNOME_VFS_OK)
    {
        result = gnome_vfs_write(hd_write,buf,sz_read,&sz_write);
        if(result != GNOME_VFS_OK)
        {
            update_gnome_vfs_perror(result,filename);
            break;
        }
        result = gnome_vfs_read(hd_read,buf,BYTES_OVER_HTTP,&sz_read);
    }

    gnome_vfs_close(hd_read);
    gnome_vfs_close(hd_write);

}

static void update_gnome_vfs_perror(GnomeVFSResult result,
        const gchar *uri)
{
    const gchar *err;

    err = gnome_vfs_result_to_string(result);
    g_print("Error %s occured opening location %s\n",err,uri);

    return;
}

static gchar *update_filename_from_uri(const gchar *uri)
{
    gchar *striped;
    gchar **r;
    gchar *prev;
    gint i;

    striped = update_get_strip_uri(uri);

    r = g_strsplit_set(striped,"/",1024);

    for(i=0;r[i];i++)
        prev = r[i];

    prev = g_strdup(prev);

    g_free(striped);
    g_strfreev(r);
   
    return prev;
}

static void update_get_html_recur(xmlNodePtr node,const gchar *book_dir)
{
   xmlNodePtr cur;
   gchar *html_uri;
   gchar *filename;
   gchar *qname; /* qualified name */
   gchar *fullname;
   gchar *quri;
   gchar *uri;

   cur = node;

   while(cur != NULL)
   {
       if(xmlStrcmp(cur->name,"sub") == 0){

           if(cur->children != NULL)
           {
               html_uri = xmlGetProp(cur,"link");
               /* strip anchor from qualified uri */
               uri = update_get_strip_uri(html_uri);

               /* get filename */
               filename = update_filename_from_uri(uri);
               qname = g_strconcat(filename,".htm",NULL);
               fullname = g_build_filename(book_dir,qname,NULL);

               /* get uri to query */ 
               quri = g_strconcat(uri,QUERY_CACHE,NULL);

               /* download a html file */
               update_save_html_from_uri(quri,fullname);

               /* free all */
               g_free(html_uri);
               g_free(uri);
               g_free(filename);
               g_free(qname);
               g_free(fullname);
               g_free(quri);
               
               /* recur */
               update_get_html_recur(cur->children,book_dir);

           }

       }else if (xmlStrcmp(cur->name,"chapter") == 0){

           if(cur->children != NULL)
               update_get_html_recur(cur->children,book_dir);

       }

       cur = cur->next;
   }

    return;
}

/* must be freed */
static gchar *dh_escape_uri(const gchar *uri)
{
    return xmlURIEscapeStr(uri,":/");
}
